---------------------------------------
-----  Basic Japanese descriptions ----
---------------------------------------
-- Last Update: 2025-09-16

-- FORMAT: Item ID | Name | Description
-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  ! = Warning  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "ja_jp"

-- init Japanese table
EID.descriptions[languageCode] = {}
EID.descriptions[languageCode].custom = {} -- table for custom entity descriptions
EID.descriptions[languageCode].languageName = "Japanese"
EID.descriptions[languageCode].alternativeLanguageCodes = {"japanese", "jp", "ja"}

-- Fonts to be used with this language pack
EID.descriptions[languageCode].fonts = {{name="default", lineHeight= 12}, {name="inverted", lineHeight = 12}, {name="borderless", lineHeight= 12}}

---------- Collectibles ----------

EID.descriptions[languageCode].collectibles={
    {"1", "悲しみオニオン", "↑ 連射速度 +0.7"}, -- The Sad Onion
    {"2", "心眼", "トリプルショットの涙#↓ 連射速度"}, -- The Inner Eye
    {"3", "スプーン曲げ", "涙にホーミング効果を付与"}, -- Spoon Bender
    {"4", "クリケットの頭", "↑ 攻撃力 +0.5#↑ 攻撃力 +50%"}, -- Cricket's Head
    {"5", "リフレクション", "涙にブーメラン軌道を付与#↑ 射程　　 +1.5#↑ 弾速　　 +0.6#↑ 涙の高さ +1"}, -- My Reflection
    {"6", "ナンバー ワン", "↑ 連射速度 +1.5#↓ 射程　　 -17.62#↑ 涙の高さ +0.76"}, -- Number One
    {"7", "殉教者の血", "↑ 攻撃力 +1#{{Collectible34}} ベリアルの本 または#{{Card16}} 悪魔のカード 使用時、 攻撃力が追加で50%アップ"}, -- Blood of the Martyr
    {"8", "ボビー君", "3.5 ダメージのノーマルな 涙で攻撃する使い魔"}, -- Brother Bobby
    {"9", "スカトール", "ハエタイプの敵が中立化し、 無害になる"}, -- Skatole
    {"10", "ハエの光輪", "二匹の黒いハエが アイザックを周回し、 敵の弾をブロックする"}, -- Halo of Flies
    {"11", "1up!", "↑ 追加ライフ +1#死ぬと、一つ前の部屋に 体力全回復の状態で復活"},
    {"12", "魔法のキノコ", "体力全回復#↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 攻撃力　 +50%#↑ 射程　　 +5.25#↑ 移動速度 +0.3#↑ 涙の高さ +0.5#アイザックのサイズ拡大"}, -- Magic Mushroom
    {"13", "ウイルス", "接触した敵に毒を与える#毒を受けた敵が死んだ時、 20%の確率で黒ハートを 落とす#↓ 移動速度 -0.1"}, -- The Virus
    {"14", "ロイド レイジ", "↑ 移動速度 +0.6#↑ 射程　　 +5.25#↑ 涙の高さ +0.5"}, -- Roid Rage
    {"15", "<3", "↑ 最大体力 +1#体力全回復"},
    {"16", "生肝", "↑ 最大体力 +2#体力全回復"}, -- Raw Liver
    {"17", "ガイコツの鍵", "鍵 +99"}, -- Skeleton Key
    {"18", "１ドル", "コイン +99"}, -- A Dollar
    {"19", "ドカーン！", "爆弾 +10"}, -- Boom!
    {"20", "現世からの超越", "飛行能力を付与"}, -- Transcendence
    {"21", "コンパス", "部屋のアイコンが マッピングされる"}, -- The Compass
    {"22", "昼ごはん", "↑ 最大体力 +1"}, -- Lunch
    {"23", "晩ごはん", "↑ 最大体力 +1"}, -- Dinner
    {"24", "デザート", "↑ 最大体力 +1"}, -- Dessert
    {"25", "朝ごはん", "↑ 最大体力 +1"}, -- Breakfast
    {"26", "腐った肉", "↑ 最大体力 +1"}, -- Rotten Meat
    {"27", "木のスプーン", "↑ 移動速度 +0.3"}, -- Wooden Spoon
    {"28", "ベルト", "↑ 移動速度 +0.3"}, -- The Belt
    {"29", "ママの下着", "↑ 射程　　 +5.25#↑ 涙の高さ +0.5"}, -- Mom's Underwear
    {"30", "ママのヒール", "↑ 射程　　 +5.25#↑ 涙の高さ +0.5"}, -- Mom's Heels
    {"31", "ママの口紅", "↑ 射程　　 +5.25#↑ 涙の高さ +0.5"}, -- Mom's Lipstick
    {"32", "コートハンガー", "↑ 連射速度 +0.7"}, -- Wire Coat Hanger
    {"33", "聖書", "その部屋に居る間、 飛行能力を付与#ママを即死させる#!!! サタン戦で使用すると アイザックが即死する"}, -- The Bible
    {"34", "ベリアルの本", "↑ 攻撃力 +2#↑ 悪魔部屋／天使部屋の 出現率 +12.5%#{{Collectible7}} 殉教者の血を所有時、 攻撃力が追加で50%増"}, -- The Book of Belial
    {"35", "ネクロノミコン", "部屋の全ての敵に 40ダメージを与える"}, -- The Necronomicon
    {"36", "うんち", "うんちを出し、敵を ノックバックさせる#一マスの穴の手前に 出して爆破すると、 橋の代わりになる"}, -- The Poop
    {"37", "Mr.ドカーン", "大型の爆弾を設置する#爆発は110ダメージを与える"}, -- Mr. Boom
    {"38", "タミーの頭", "円形に10発の涙を同時発射"}, -- Tammy's Head
    {"39", "ママのブラ", "部屋の全ての敵を4秒間 石化させる"}, -- Mom's Bra
    {"40", "カミカゼ！", "自爆攻撃#爆発は40ダメージを与える"}, -- Kamikaze!
    {"41", "ママのナプキン", "部屋の全ての敵を5秒間 恐怖状態にする"}, -- Mom's Pad
    {"42", "ボブの腐った頭", "手投げ式の毒爆弾"}, -- Bob's Rotten Head
    {"43", "", "<item does not exist>"},
    {"44", "瞬間移動", "ランダムな部屋に テレポートする#{{Blank}} (I AM ERRORを除く)"}, -- Teleport!
    {"45", "ヤム ハート", "赤ハートを1回復"}, -- Yum Heart
    {"46", "幸せの足", "↑ 運 +1#ギャンブルの勝率アップ#部屋クリア時の報酬 スポーン確率アップ"}, -- Lucky Foot
    {"47", "ドクターのスイッチ", "指定地点にミサイルを 落とす#ミサイルは攻撃力ｘ20の ダメージを与える"}, -- Doctor's Remote
    {"48", "キューピッドの矢", "涙に貫通効果を付与"}, -- Cupid's Arrow
    {"49", "シュープ ダ ウープ！", "ブリムストーンの レーザービームを発射"}, -- Shoop Da Whoop!
    {"50", "スティーブン", "↑ 攻撃力 +1"}, -- Steven
    {"51", "ペンタグラム", "↑ 攻撃力 +1#↑ 悪魔部屋／天使部屋の 出現率 +10%"}, -- Pentagram
    {"52", "Dr. フィータス", "涙が爆弾に置き換わる#爆弾は攻撃力ｘ5+30の ダメージを与える#↓ 連射間隔 ｘ2.5"}, -- Dr. Fetus
    {"53", "マグネット", "ピックアップが障害物を 飛び越えてアイザックに 引き寄せられるようになる"}, -- Magneto
    {"54", "宝の地図", "フロアの構造が マッピングされる"}, -- Treasure Map
    {"55", "ママの目", "一定確率で涙が後ろにも 発射されるようになる#確率：運0=50%、2=100%"}, -- Mom's Eye
    {"56", "レモンの災い", "レモン汁が床に広がり、 触れた敵に毎秒24の ダメージを与える"}, -- Lemon Mishap
    {"57", "遠くからの称賛", "赤いハエがアイザックを 周回し、接触した敵に 毎秒75ダメージを与える"}, -- Distant Admiration
    {"58", "ブック オブ シャドウ", "ダメージを無効化する シールドを10秒間付与"}, -- Book of Shadows
    {"59", "", "<item does not exist>"},
    {"60", "ハシゴ", "一マス分の穴にハシゴが かかり、横断可能になる"}, -- The Ladder
    {"61", "", "<item does not exist>"},
    {"62", "ヴァンパイア チャーム", "敵を13体倒すたび、 半赤ハート回復する"}, -- Charm of the Vampire
    {"63", "電池", "アクティブアイテムの チャージの最大容量が 2回分になる"}, -- The Battery
    {"64", "スチームセール", "お店の商品が半額になる#このアイテムを2個取得 すると商品が無料になる"}, -- Steam Sale
    {"65", "アナーキストの料理本", "トロル爆弾を6個スポーン"}, -- Anarchist Cookbook
    {"66", "砂時計", "部屋の全ての敵を8秒間 スロー状態にする"}, -- The Hourglass
    {"67", "マギーちゃん", "3.5 ダメージのノーマルな 涙で攻撃する使い魔"}, -- Sister Maggy
    {"68", "テクノロジー", "涙が貫通・無限射程の レーザーに置き換わる"}, -- Technology
    {"69", "チョコレートミルク", "涙がチャージ式になり、 チャージ量に応じて 10～400%のダメージを 与える#↓ 連射速度"}, -- Chocolate Milk
    {"70", "成長ホルモン", "↑ 攻撃力　 +1#↑ 移動速度 +0.4"}, -- Growth Hormones
    {"71", "ミニ マッシュ", "↑ 移動速度 +0.3#↓ 射程　　 -4.25#↑ 涙の高さ +1.5#↑ アイザックのサイズ縮小"}, -- Mini Mush
    {"72", "ロザリー", "青ハート +3#{{Collectible33}} 聖書が全てのアイテム プールに追加される"}, -- Rosary
    {"73", "肉の塊", "肉塊がアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#複数個取得で進化：#{{Blank}} 2：涙で攻撃#{{Blank}} 3：ミートボーイになり、 　 敵を追いかけ攻撃#{{Blank}} 4：ミートボーイ LV2#5個目からはループ"}, -- Cube of Meat
    {"74", "クォーター", "コイン +25"}, -- A Quarter
    {"75", "PHD", "全てのピルが識別される#悪性のピルを良性に変換#取得時、ランダムなピルを 1個スポーンする#赤ハートを2個回復#売血時のコイン +0～2"},
    {"76", "エックス線ビジョン", "隠し部屋が自動的に開く"}, -- X-Ray Vision
    {"77", "マイ リトル ユニコーン", "6秒間無敵状態になり、 接触した敵に毎秒40の ダメージを与え、移動 速度が0.28アップする"}, -- My Little Unicorn
    {"78", "ヨハネの黙示録", "青ハートを1個付与する#使用すると、現フロアの ボスがハービンガーに 時々置き換えられる#↑ 保持中、悪魔部屋／天使 部屋の出現率 +17.5%"}, -- Book of Revelations
    {"79", "紋章", "↑ 攻撃力　 +1#↑ 移動速度 +0.2#青ハート +1"}, -- The Mark
    {"80", "契約", "↑ 攻撃力　 +0.5#↑ 連射速度 +0.7#青ハート +2"}, -- The Pact
    {"81", "ねこのしかばね", "↑ 追加ライフ +9#↓ 最大体力を1に設定する#死ぬと、最大体力が1の 状態で、一つ前の部屋に 復活する"}, -- Dead Cat
    {"82", "奈落の王", "飛行能力を付与#↑ 移動速度 +0.3"}, -- Lord of the Pit
    {"83", "釘", "青ハートを1個付与する#↑ 攻撃力　 +0.7#↓ 移動速度 -0.18#毎秒40の接触ダメージ 効果を得る#障害物を破壊できる"}, -- The Nail
    {"84", "もっと深く！", "次のフロアにつながる トラップドアを生成#10%の確率でクロール スペースにつながる"}, -- We Need to Go Deeper!
    {"85", "カードのデッキ", "ランダムなカードを 1枚スポーンする"}, -- Deck of Cards
    {"86", "モンストロの歯", "モンストロを召喚し、 踏み潰し攻撃で敵に 120ダメージを与える"}, -- Monstro's Tooth
    {"87", "ロキのツノ", "一定確率で涙が四方向に 発射されるようになる#確率：運0=25%、7=100%"}, -- Loki's Horns
    {"88", "リトルチャビー", "涙の発射方向に連動して 突進する使い魔#毎秒52.5の接触ダメージ"}, -- Little Chubby
    {"89", "スパイダー バイト", "一定確率で涙にスロー 効果を付与する#確率：運0=25%、15=100%"}, -- Spider Bite
    {"90", "小岩", "↑ 攻撃力　 +1#↑ 連射速度 +0.2#↓ 移動速度 -0.2"}, -- The Small Rock
    {"91", "スペランカーの帽子", "隣接する部屋の種類が マップに表示される#隠し部屋の位置も表示"}, -- Spelunker Hat
    {"92", "スーパー包帯", "↑ 最大体力 +1#青ハート +2#体力を1回復"}, -- Super Bandage
    {"93", "ゲームキッド", "6秒間パックマン化し、 以下の効果を得る：#無敵状態#全ての敵に恐怖を与える#40の接触ダメージ#敵を倒すと確率で 半赤ハート回復#涙攻撃不可"}, -- The Gamekid
    {"94", "サック オブ ぺニーズ", "2部屋クリアするたび コインを1枚スポーン する使い魔"}, -- Sack of Pennies
    {"95", "ロボベイビー", "3.5 ダメージのレーザーで 攻撃する使い魔"}, -- Robo-Baby
    {"96", "リトルチャッド", "3部屋クリアするたび 半赤ハートをスポーン する使い魔"}, -- Little C.H.A.D.
    {"97", "罪の書", "ランダムなピックアップを 1個スポーンする"}, -- The Book of Sin
    {"98", "遺物", "5～6部屋クリアするたび 1個の青ハートをスポーン する使い魔"}, -- The Relic
    {"99", "リトル ギッシュ", "3.5 ダメージのスロー効果 付き涙で攻撃する使い魔"}, -- Little Gish
    {"100", "リトル スティーブン", "3.5 ダメージのホーミング 効果付き涙で攻撃する 使い魔"}, -- Little Steven
    {"101", "ヘイロー", "↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 連射速度 +0.2#↑ 射程　　 +0.25#↑ 移動速度 +0.3#↑ 涙の高さ +0.5"}, -- The Halo
    {"102", "ママの薬入れ", "ランダムなピルを1個 スポーンする"}, -- Mom's Bottle of Pills
    {"103", "流行風邪", "一定確率で毒の涙を放つ#確率：運0=25%、12=100%"}, -- The Common Cold
    {"104", "パラサイト", "衝突した涙が二つに分裂する#分裂した涙はダメージ量が 半減する"}, -- The Parasite
    {"105", "The D6", "部屋の全てのアイテムを リロールする"},
    {"106", "ミスターメガ", "↑ 爆弾ダメージｘ2.25#↑ 爆発範囲#爆弾 +5"}, -- Mr. Mega
    {"107", "ピンキング シアー", "頭と体を分離し、浮遊状態 になった頭部を操作する#体が敵を自動的に追いかけ、 毎秒82.5の接触ダメージを 与える"}, -- The Pinking Shears
    {"108", "ウェイファー", "受けるダメージを 半ハートに軽減する"}, -- The Wafer
    {"109", "お金は権力なり", "↑ 攻撃力 +0.04ｘ所持金"}, -- Money = Power
    {"110", "ママのコンタクト", "20%の確率で涙に 石化効果を付与する#↑ 射程　　 +0.25#↑ 涙の高さ +0.5"}, -- Mom's Contacts
    {"111", "まめ", "おならをし、近くの敵に 5ダメージと毒を与える"}, -- The Bean
    {"112", "ガーディアン エンジェル", "天使がアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#毎秒105の接触ダメージ#周回タイプの使い魔の 回転速度が上がる"}, -- Guardian Angel
    {"113", "デーモンベイビー", "3 ダメージの涙で近くの 敵を自動攻撃する使い魔"}, -- Demon Baby
    {"114", "ママの包丁", "涙がナイフに置き換わる#保持中のナイフは2倍の ダメージを与える#チャージ攻撃でナイフを 発射でき、折り返し地点 では6倍のダメージを与える"}, -- Mom's Knife
    {"115", "ウィジャボード", "涙に透過効果を付与"}, -- Ouija Board
    {"116", "９ボルト", "アクティブアイテムを フルチャージ#アクティブアイテムの 必要チャージ量が1減る#必要チャージ量が1の アイテムは、15秒の 時間式になる#時間式のアイテムは、 その時間が半減する"}, -- 9 Volt
    {"117", "鳥の死体", "ダメージを受けると鳥が 現れ、その部屋に居る間、 敵を追いかけて攻撃する#毎秒4.3の接触ダメージ"}, -- Dead Bird
    {"118", "ブリムストーン", "涙がチャージ式のレーザー ビームに置き換わる"}, -- Brimstone
    {"119", "血液袋", "↑ 最大体力 +1#↑ 移動速度 +0.3#体力を4回復"}, -- Blood Bag
    {"120", "変なキノコ", "↑ 連射速度 +1.7#↑ 移動速度 +0.3#↓ 攻撃力　 -10%#↓ 攻撃力　 -0.4"}, -- Odd Mushroom
    {"121", "変なきのこ", "↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 射程　　 +0.25#↑ 涙の高さ +0.5#↓ 移動速度 -0.1"}, -- Odd Mushroom
    {"122", "バビロンの女", "残り体力が半赤ハート 以下の時：#↑ 攻撃力　 +1.5#↑ 移動速度 +0.3"}, -- Whore of Babylon
    {"123", "モンスター マニュアル", "ランダムな使い魔を 1体付与する#その部屋でのみ有効"}, -- Monster Manual
    {"124", "死海文書", "ランダムなアクティブ アイテムの効果を発動"}, -- Dead Sea Scrolls
    {"125", "ボビーボム", "爆弾がホーミング化#爆弾 +5"}, -- Bobby-Bomb
    {"126", "レイザー ブレード", "ハート1個のダメージを 受け、その部屋に居る間、 攻撃力を1.2増やす#赤ハートを優先して消費"}, -- Razor Blade
    {"127", "フォーゲットミーなぅ", "現在のフロアを再生成する"}, -- Forget Me Now
    {"128", "永遠の孤独", "青いハエがアイザックを 周回し、接触した敵に 毎秒30ダメージを与える"}, -- Forever Alone
    {"129", "一杯の背アブラ", "↑ 最大体力 +2#↓ 移動速度 -0.2#体力0.5回復"}, -- Bucket of Lard
    {"130", "ポニー", "保持中、飛行能力を付与し、 1.5以下の移動速度を 1.5に修正する#使用すると進行方向に 無敵状態で突進し、 敵に40ダメージを与える"}, -- A Pony
    {"131", "ボム袋", "3部屋クリアするたび 爆弾を1個スポーンする 使い魔"}, -- Bomb Bag
    {"132", "炭の塊", "飛距離に応じて涙の ダメージが増加する"}, -- A Lump of Coal
    {"133", "ガッピーの足", "最大体力1個を 青ハート3個に変換"}, -- Guppy's Paw
    {"134", "ガッピーの尻尾", "部屋のクリア報酬が 33%の確率で宝箱に、 22%の確率で無報酬に、 それぞれ置き換わる"}, -- Guppy's Tail
    {"135", "静脈注射", "いつでも売血#1ダメージ = 1～2コイン"}, -- IV Bag
    {"136", "親友", "敵を引きつけるデコイの 爆弾を設置する"}, -- Best Friend
    {"137", "デトネーター", "設置した爆弾を任意の タイミングで爆破する#初回取得時、爆弾 +5"}, -- Remote Detonator
    {"138", "聖痕", "↑ 最大体力 +1#↑ 攻撃力　 +0.3"}, -- Stigmata
    {"139", "ママのカバン", "トリンケットを2個まで 保持可能になる"}, -- Mom's Purse
    {"140", "ボブの呪い", "爆弾に毒効果を付与する#爆弾 +5"}, -- Bob's Curse
    {"141", "ページェント ボーイ", "ランダムなコインを 7枚スポーンする"}, -- Pageant Boy
    {"142", "スカプラリオ", "残り体力が半ハートに なった時、青ハートを 1個付与する#効果は1部屋で1回のみ 有効だが、部屋に入り 直すと再度有効化する"}, -- Scapular
    {"143", "スピード ボール", "↑ 移動速度 +0.3#↑ 弾速　　 +0.2"}, -- Speed Ball
    {"144", "ろくでなしフレンド", "コインを拾いランダムな ピックアップに変換する 乞食が現れる#3～4枚で1ピックアップ"}, -- Bum Friend
    {"145", "ガッピーの頭", "青ハエを2～4匹スポーン"}, -- Guppy's Head
    {"146", "祈りのカード", "白ハートを1個付与"}, -- Prayer Card
    {"147", "大斧", "その部屋に居る間、斧で 障害物や壁を破壊できる"}, -- Notched Axe
    {"148", "感染者", "ダメージを受けるたび、 青ハエが1～3匹スポーン"}, -- Infestation
    {"149", "吐き気薬", "涙が毒爆弾に置き換わる#↑ 攻撃力 +40#↓ 連射速度"}, -- Ipecac
    {"150", "タフなラブ", "一定確率で涙が歯に置き 換わり、攻撃力ｘ3.2の ダメージを与える#確率：運0=10%、9=100%"}, -- Tough Love
    {"151", "ザ ムリガン", "涙が敵に当たった時、 1/6の確率で青ハエが スポーンする"}, -- The Mulligan
    {"152", "テクノロジー２", "右目の涙が連続照射の 貫通レーザーに置き換わる#↓ 攻撃力 -35%#レーザーは攻撃力ｘ0.2の ダメージを与える"}, -- Technology 2
    {"153", "ミュータント スパイダー", "クアッドショットの涙#↓ 連射速度"}, -- Mutant Spider
    {"154", "ケミカルピール", "↑ 左目の攻撃力 +2"}, -- Chemical Peel
    {"155", "ノゾキ魔", "目玉が部屋を飛び回り、 接触した敵に毎秒17の ダメージを与え、弾を ブロックする"}, -- The Peeper
    {"156", "悪い癖", "ダメージを受けるたび アクティブアイテムが 1チャージされる"}, -- Habit
    {"157", "血まみれの欲望", "↑ ダメージを受けるたび 攻撃力がアップ (最大6回、+6)#効果は次のフロアまで有効"}, -- Bloody Lust
    {"158", "水晶", "フルマッピング効果#青ハートまたはカード・ ルーンのいずれか1個を スポーンする"}, -- Crystal Ball
    {"159", "夜の神霊", "飛行能力を付与#涙に透過効果を付与"}, -- Spirit of the Night
    {"160", "空の轟音", "5本の光線が降り注ぎ、 触れた敵に攻撃力+20の ダメージを与える"}, -- Crack the Sky
    {"161", "アンク", "{{Player4}} 死ぬと、一つ前の部屋に ？？？として復活する"}, -- Ankh
    {"162", "ケルトの十字架", "ダメージを受けた時、一定 確率でシールドを展開する#シールドは7秒間持続し、 全てのダメージを無効化#確率：運0=20%、27=100%"}, -- Celtic Cross
    {"163", "ゴーストベイビー", "3.5 ダメージの透過効果 付き涙で攻撃する使い魔"}, -- Ghost Baby
    {"164", "キャンドル", "ロウソクから青い炎を放つ#炎が敵にダメージを与え、 弾をブロックする#炎は2秒で燃え尽きる"}, -- The Candle
    {"165", "九尾のネコ", "↑ 攻撃力 +1#↑ 弾速　 +0.23"}, -- Cat-O-Nine-Tails
    {"166", "D20", "部屋の全ての宝箱と ピックアップをリロール"},
    {"167", "道化師ベイビー", "4 ダメージの涙をＶ字形に 発射して攻撃する使い魔"}, -- Harlequin Baby
    {"168", "偉大なフィータス", "涙が誘導ミサイルに置き 換わり、攻撃力ｘ20の ダメージを与える"}, -- Epic Fetus
    {"169", "ポリフェムス", "↑ (攻撃力 +4)ｘ2#↓ (連射間隔ｘ2.1) +3#敵を倒した涙は減衰して 貫通する"}, -- Polyphemus
    {"170", "あしながおじさん", "5秒に1回、巨大な足が敵を 踏み潰し、40のダメージを 与える"}, -- Daddy Longlegs
    {"171", "スパイダー バット", "部屋の全ての敵に 10ダメージを与え、  4秒間スロー状態にする"}, -- Spider Butt
    {"172", "イケニエの短刀", "短剣がアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#毎秒225の接触ダメージ"}, -- Sacrificial Dagger
    {"173", "司教の冠", "赤ハートが50%の確率で 青ハートに置き換わって スポーンする"}, -- Mitre
    {"174", "レインボーベイビー", "3～5ダメージのランダムな 特殊効果付き涙で攻撃する 使い魔"}, -- Rainbow Baby
    {"175", "パパのカギ", "現在の部屋の全ドアと 隠し部屋の入り口を開く#条件を満たしていない {{ChallengeRoom}}{{BossRushRoom}}チャレンジルーム・ メガサタンのドアも開く"}, -- Dad's Key
    {"176", "幹細胞", "↑ 最大体力 +1#↑ 弾速　　 +0.16"}, -- Stem Cells
    {"177", "携帯スロットマシーン", "コインを1枚消費して スロットを回す"}, -- Portable Slot
    {"178", "聖水", "アイザックに追従し、 ダメージを受けると 砕け、床に聖水をまく#聖水は9秒間持続し、 触れた敵に毎秒24の ダメージを与える"}, -- Holy Water
    {"179", "運命", "飛行能力を付与#白ハート +1"}, -- Fate
    {"180", "黒豆", "ダメージを受けると おならをし、近くの敵に 5ダメージと毒を与える"}, -- The Black Bean
    {"181", "ホワイトポニー", "保持中、飛行能力を付与し、 1.5以下の移動速度を 1.5に修正する#使用すると進行方向に 無敵状態で突進し、 接触した敵に40ダメージ#突進時に光線が降り注ぎ、 触れた敵に攻撃力+20の ダメージを与える"}, -- White Pony
    {"182", "聖なる心臓", "体力全回復#↑ 最大体力 +1#↑ 攻撃力　 +230%#↑ 攻撃力　 +1#↓ 連射速度 -0.4#↓ 弾速　　 -0.25#↑ 射程　　 +0.38#↑ 涙の高さ +0.75#涙にホーミング効果を付与"}, -- Sacred Heart
    {"183", "つまようじ", "↑ 連射速度 +0.7#↑ 弾速　　 +0.16"}, -- Tooth Picks
    {"184", "聖杯", "飛行能力を付与#↑ 最大体力 +1"}, -- Holy Grail
    {"185", "鳩の死体", "飛行能力を付与#涙に透過効果を付与"}, -- Dead Dove
    {"186", "血印", "ハート 1個のダメージを 受け、部屋の全ての敵に 40のダメージを与える#赤ハートを優先して消費"}, -- Blood Rights
    {"187", "ガッピーの毛玉", "毛玉がアイザックを追従し、 敵に接触ダメージを与え、 弾をブロックする#毛玉で敵を倒すたび毛玉の サイズとダメージがアップ （5段階、5→13ダメージ）"}, -- Guppy's Hairball
    {"188", "アベル", "アイザックと鏡映しに 移動・攻撃する使い魔#3.5 ダメージのノーマルな 涙で攻撃する"}, -- Abel
    {"189", "SMB熱狂的ファン", "体力全回復#↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 連射速度 +0.2#↑ 射程　　 +0.5#↑ 移動速度 +0.2#↑ 涙の高さ +1"}, -- SMB Super Fan
    {"190", "パイロ", "爆弾 +99"}, -- Pyro
    {"191", "３ドル札", "2～3秒ごとにランダムな 特殊効果を涙に付与"}, -- 3 Dollar Bill
    {"192", "初心者向けテレパシー", "その部屋に居る間、涙に ホーミング効果を付与"}, -- Telepathy for Dummies
    {"193", "肉っ！", "↑ 最大体力 +1#↑ 攻撃力　 +0.3"}, -- MEAT!
    {"194", "魔法の８ボール", "↑ 弾速 +0.16#取得時、ランダムな カードを1枚スポーン"}, -- Magic 8 Ball
    {"195", "ママの小銭入れ", "ランダムなピルを 4個スポーン"}, -- Mom's Coin Purse
    {"196", "ぷにぷに", "↑ 連射速度 +0.4#取得時、青ハートを 2個スポーン"}, -- Squeezy
    {"197", "ジーザス ジュース", "↑ 攻撃力　 +0.5#↑ 射程　　 +0.25#↑ 涙の高さ +0.5"}, -- Jesus Juice
    {"198", "箱", "取得時、ピックアップを 各種1個ずつスポーン"}, -- Box
    {"199", "ママのカギ", "鍵 +2#宝箱から得られる ピックアップ量2倍"}, -- Mom's Key
    {"200", "ママのアイシャドー", "一定確率で涙に チャーム効果を付与#確率：運0=10%、27=100%"}, -- Mom's Eyeshadow
    {"201", "鉄の塊", "↑ 攻撃力 +0.3#一定確率で涙に 混乱効果を付与する#確率：運0=10%、27=100%"}, -- Iron Bar
    {"202", "マイダスタッチ", "接触した敵へ所持金に 応じたダメージを与え、 黄金化し、動きを止める#黄金化状態の敵を倒すと 1～4枚のコインを落とす#うんちをスポーンする時、 黄金うんちになる可能性が アップする"}, -- Midas' Touch
    {"203", "ハンブリングバンドル", "コイン・鍵・爆弾・ハートを ダブルバージョンに変換する"}, -- Humbleing Bundle
    {"204", "ファニーパック", "ダメージを受けた時、 50%の確率でコイン・ 鍵・爆弾・ハートの いずれかをスポーン"}, -- Fanny Pack
    {"205", "シャーププラグ", "アクティブアイテムの チャージ量が空の時に 使用ボタンを押すと、 ハート2個のダメージが 発生し、アイテムが フルチャージされる"}, -- Sharp Plug
    {"206", "ギロチン", "↑ 攻撃力　 +1#↑ 連射間隔 -1#アイザックの頭部が切り 離され、胴体を周回する#頭部はダメージを受けず、 弾をブロックできる#頭部は接触した敵に毎秒 105ダメージを与える"}, -- Guillotine
    {"207", "包帯ボール", "包帯玉がアイザックを 周回し、接触した敵に ダメージを与え、弾を ブロックする#複数個取得で進化#2：チャーム効果付き涙で 　 攻撃する#3：バンデージガールに　　 　 なり、敵を追いかけ　　 　 攻撃する#4：バンデージガール LV2#5個目からはループ"}, -- Ball of Bandages
    {"208", "チャンピオンベルト", "↑ 攻撃力 +1#!!! チャンピオンタイプの 敵の出現率が15%増加"}, -- Champion Belt
    {"209", "ケツ爆弾", "↑ 爆弾 +5#爆弾がうんち爆弾に置き 換わり、爆発時、全ての 敵に混乱と10ダメージを 与える"}, -- Butt Bombs
    {"210", "スーパー木の葉", "1秒間静止すると無敵の 石像に変化できる"}, -- Gnawed Leaf
    {"211", "スパイダーベイビー", "ダメージを受けるたび 1～2匹の青クモがスポーン"}, -- Spiderbaby
    {"212", "ガッピーの首輪", "死ぬと、50%の確率で、 半ハートの状態で1つ 前の部屋に復活する"}, -- Guppy's Collar
    {"213", "失くしたコンタクト", "涙がシールドに包まれ、 敵の弾をブロックする#↓ 弾速 -0.15"}, -- Lost Contact
    {"214", "貧血気味", "↑ 射程 +5#ダメージを受けると、 その部屋に居る間、 敵にダメージを与える 血液が床に流れ続ける"}, -- Anemic
    {"215", "ヤギの頭", "悪魔部屋／天使部屋の 出現率が100%アップ#悪魔部屋／天使部屋の ドアが部屋を離れても 開いたままになる"}, -- Goat Head
    {"216", "儀式のローブ", "↑ 攻撃力　 +1#黒ハート +3"}, -- Ceremonial Robes
    {"217", "ママのウィッグ", "攻撃中、一定確率で 青クモがスポーン#体力を1回復#確率：運0=5%、9.5=100%"}, -- Mom's Wig
    {"218", "胎盤", "↑ 最大体力 +1#1分間に1回、50%の確率で 半赤ハート回復する"}, -- Placenta
    {"219", "古い絆創膏", "↑ 最大体力 +1#ダメージを受けた時、 一定確率で赤ハートが スポーンする#確率：運0=10%、27=50%"}, -- Old Bandage
    {"220", "サッド ボム", "爆発した爆弾が、円形に 10発の涙を拡散する#爆弾 +5"}, -- Sad Bombs
    {"221", "ゴムセメント", "涙が衝突時に跳ね返る ようになる"}, -- Rubber Cement
    {"222", "アンチグラビティ", "攻撃ボタンが押されて いる間、発射した涙が その場で静止を続ける#時間の経過または攻撃の 停止で、元の方向に涙が 発射される#↑ 連射間隔 -2"}, -- Anti-Gravity
    {"223", "放火魔", "爆発耐性を付与#爆風で赤ハートが1個回復#爆弾 +5"}, -- Pyromaniac
    {"224", "クリケットの体", "↑ 連射間隔 -1#↓ 射程　　 -10#↓ 涙サイズ +20%#衝突した涙が四つに分裂する#分裂した涙はダメージ量が 半減する"}, -- Cricket's Body
    {"225", "ギンピー", "ダメージを受けた時、 一定確率で青ハートが スポーンする#確率：運0=10%、20=50%#死んだ敵が1～10%の確率で 半赤ハートを落とす （HPが高い敵ほど高確率）"}, -- Gimpy
    {"226", "ブラックロータス", "↑ 最大体力 +1#青ハート +1#黒ハート +1"}, -- Black Lotus
    {"227", "貯金箱", "コイン +3#ダメージを受けるたび コインを1～2枚スポーン"}, -- Piggy Bank
    {"228", "ママの香水", "一定確率で涙に 恐怖効果を付与#確率：運0=15%、85=100%#↑ 連射間隔 -1"}, -- Mom's Perfume
    {"229", "モンストロの肺", "涙をチャージ式に置き換え、 一度に14発の涙を同時発射 できるようになる#↓ 連射間隔 ｘ4.3"}, -- Monstro's Lung
    {"230", "アバドン", "↑ 攻撃力　 +1.5#↑ 移動速度 +0.2#最大体力を0にし、6個の 黒ハートを付与する#一定確率で涙に 恐怖効果を付与#確率：運0=15%、85=100%"}, -- Abaddon
    {"231", "タールの塊", "一定確率で涙に スロー効果を付与#確率：運0=10%、18=100%#歩いた床にタールの跡が 残り、触れた敵をスロー 状態にする"}, -- Ball of Tar
    {"232", "ストップウォッチ", "ダメージを受けた時、 部屋の全ての敵を スロー状態にする#↑ 移動速度 +0.3"}, -- Stop Watch
    {"233", "ちっちゃな惑星", "涙がアイザックを周回して 飛ぶようになる#↑ 射程#↑ 涙の高さ +7#涙に透過効果を付与"}, -- Tiny Planet
    {"234", "感染者２", "倒された敵が青クモを スポーンする"}, -- Infestation 2
    {"235", "", "<item does not exist>"},
    {"236", "大腸菌", "アイザックと接触した 敵がうんちに変わる"}, -- E. Coli
    {"237", "死神タッチ", "涙が鎌に置き換わる#↑ 攻撃力　 +1.5#↓ 連射速度 -0.3#涙に貫通効果を付与"}, -- Death's Touch
    {"238", "カギのかけら１", "!!! メガサタンのドアを開く 鍵のかけら#↑ 天使部屋の出現率 +25%#{{EternalHeart}} 白ハートの出現率 +2%"}, -- Key Piece 1
    {"239", "カギのかけら２", "!!! メガサタンのドアを開く 鍵のかけら#↑ 天使部屋の出現率 +25%#{{EternalHeart}} 白ハートの出現率 +2%"}, -- Key Piece 2
    {"240", "実験的治療方法", "↑ ステータスをランダムに 4つアップ#↓ ステータスをランダムに 2つダウン"}, -- Experimental Treatment
    {"241", "闇からの契約", "部屋のクリア報酬が2倍に なるが、1/3の確率でゼロ 報酬になる"}, -- Contract From Below
    {"242", "悪名", "50%の確率で敵の弾を ブロックする"}, -- Infamy
    {"243", "トリニティーシールド", "アイザックの正面に 敵の弾をブロックする 盾が現れる"}, -- Trinity Shield
    {"244", "テック０.５", "涙攻撃中、ランダムな 確率で追加のレーザー 攻撃が発生する"}, -- Tech.5
    {"245", "視力２０／２０", "ダブルショットの涙"}, -- 20 / 20
    {"246", "ブルーマップ", "隠し部屋の位置が マッピングされる"}, -- Blue Map
    {"247", "ベストフレンド", "使い魔の与えるダメージが 2倍になり、サイズも拡大#ピックアップを生成する タイプの使い魔は、その 頻度が増加する"}, -- BFFS!
    {"248", "虫の知らせ", "青ハエ／クモの与える ダメージが2倍になる"}, -- Hive Mind
    {"249", "オプションあり", "ボスアイテムを2つの 候補から選択できる"}, -- There's Options
    {"250", "ＢＯＧＯボム", "全ての爆弾がダブル バージョンに置き換わる"}, -- Bogo Bombs
    {"251", "スターターデッキ", "カードを2枚まで 保持可能になる#全てのピルをカードに 置き変える#取得時、ランダムな カードを1枚スポーン"}, -- Starter Deck
    {"252", "こぶくろ", "ピルを2個まで 保持可能になる#全てのカードをピルに 置き変える#取得時、ランダムな ピルを1個スポーン"}, -- Little Baggy
    {"253", "魔法のかさぶた", "↑ 運　　　 +1#↑ 最大体力 +1"}, -- Magic Scab
    {"254", "血づまり", "左目のみに適用：#↑ 攻撃力 +1#↑ 射程　 +5"}, -- Blood Clot
    {"255", "スクリュー", "↑ 連射速度 +0.5#↑ 弾速　　 +0.2"}, -- Screw
    {"256", "あつあつボム", "爆弾が炎をまとい、敵に 接触ダメージを与える#爆発地点に炎が残り、 敵にダメージを与える#爆弾 +5"}, -- Hot Bombs
    {"257", "ファイヤーマインド", "涙に火傷効果を付与する#一定確率で敵と衝突した 涙が爆発し、炎を残す#確率：運0=10%、13=100%#!!! 自爆の危険あり"}, -- Fire Mind
    {"258", "けつばん", "取得時と毎フロア開始時、 全てのパッシブアイテムと ステータスをリロールする"}, -- Missing No.
    {"259", "ダークマター", "↑ 攻撃力 +1#一定確率で涙に 恐怖効果を付与#確率：運0=33%、20=100%"}, -- Dark Matter
    {"260", "ブラックキャンドル", "フロアの呪いを無効化#黒ハート +1#悪魔部屋／天使部屋の 出現率 +15%"}, -- Black Candle
    {"261", "プロップトーシス", "↑ 攻撃力 +100%#↓ 涙のサイズとダメージが 飛距離と共に減少する"}, -- Proptosis
    {"262", "失われたページ２", "黒ハート +1#ダメージを受け、残りの 体力がハート1個以下に なった時、ネクロノミコン 効果が発動する (全ての敵に40ダメージ)"}, -- Missing Page 2
    {"263", "", "<item does not exist>"},
    {"264", "スマートフライ", "黄色いハエがアイザックを 周回し、敵に接触ダメージ を与え、弾をブロックする#ダメージを受けると アイザックから離れ、 敵を追いかけ攻撃する#毎秒22.5の接触ダメージ"}, -- Smart Fly
    {"265", "乾燥ベイビー", "アイザックを追従し、 敵の弾をブロックする 使い魔#弾ブロック時、10%の 確率でネクロノミコン 効果を発動する"}, -- Dry Baby
    {"266", "ジューシー袋", "触れた敵をスロー状態に する液体を流しながら アイザックを追従する 使い魔#部屋をクリアするたび 1～2匹の青クモをスポーン"}, -- Juicy Sack
    {"267", "ロボベイビー改", "攻撃方向に連動して移動し、 正面の敵を自動でレーザー 攻撃する使い魔#レーザーは3.5ダメージを 与える"}, -- Robo-Baby 2.0
    {"268", "腐ったベイビー", "青ハエをスポーンして 攻撃する使い魔"}, -- Rotten Baby
    {"269", "頭なしベイビー", "床に血を流しながら アイザックを追従する 使い魔#血は触れた敵に毎秒 6ダメージを与える"}, -- Headless Baby
    {"270", "ヒル", "敵を追いかけ攻撃し、 毎秒3.2ダメージを 与える使い魔#この使い魔が敵を倒した時、 半赤ハート回復する"}, -- Leech
    {"271", "謎の袋", "5～6部屋クリアするたび ランダムなピックアップを 1個スポーンする使い魔"}, -- Mystery Sack
    {"272", "BBF", "部屋を飛び回り、敵との 接触時に爆発する使い魔#接触で10、爆発で60の ダメージを与える"},
    {"273", "ボブの脳みそ", "涙の発射方向に連動して 飛び出し、敵との衝突で 爆発する使い魔#爆発は60のダメージと 毒を与える"}, -- Bob's Brain
    {"274", "ベストバディー", "ダメージを受けると白い ハエが現れ、その部屋に 居る間、アイザックを 周回する#毎秒75の接触ダメージ"}, -- Best Bud
    {"275", "小さなブリムストーン", "ブリムストーンで攻撃する 使い魔　　#ビームは完全ヒット時、 31.5のダメージを与える"}, -- Lil Brimstone
    {"276", "アイザックの心臓", "アイザックに追従する 心臓が現れ、ダメージ 判定が心臓側に移行する"}, -- Isaac's Heart
    {"277", "チビホーント", "敵を追いかけて攻撃し、 毎秒4ダメージを与え、 恐怖状態にする使い魔"}, -- Lil Haunt
    {"278", "ダークバム", "赤ハートを拾い集める 乞食の使い魔#1.5個拾うたび、青ハート・ 青クモ・敵クモのいずれかを スポーンする"}, -- Dark Bum
    {"279", "ビッグファン", "巨大なハエがアイザックを 周回し、敵に接触ダメージ を与え、弾をブロックする#毎秒8.57の接触ダメージ"}, -- Big Fan
    {"280", "あしなが雑魚", "バトル中、最大5匹まで 青クモをスポーンする 使い魔"}, -- Sissy Longlegs
    {"281", "サンドバッグ", "アイザックの代わりに 敵の標的になる使い魔"}, -- Punching Bag
    {"282", "ジャンプの仕方", "移動しながら使用すると その方向にジャンプする"}, -- How to Jump
    {"283", "D100", "部屋の全てのアイテム、 ピックアップ、宝箱、 取得済みのパッシブ アイテムをリロールする"},
    {"284", "D4", "全ての取得済みパッシブ アイテムをリロールする"},
    {"285", "D10", "部屋の全ての敵をリロール"},
    {"286", "白紙のカード", "保持中のカード・ルーンの 効果をコピーして発動する"}, -- Blank Card
    {"287", "秘儀の書", "{{Collectible54}} 宝の地図#{{Collectible21}} コンパス#{{Collectible246}} ブルーマップ いずれかの効果を 現フロアに付与する"}, -- Book of Secrets
    {"288", "スパイダーボックス", "1～4匹の青クモをスポーン"}, -- Box of Spiders
    {"289", "赤いロウソク", "ロウソクから赤い炎を放つ#炎が敵にダメージを与え、 弾をブロックする#接触とブロックで炎は 縮み、4回ヒットで消滅"}, -- Red Candle
    {"290", "入れ物", "体力が満タンの状態で 赤ハートを拾うと、最大 4個までストックできる#使用すると、中身を全て その場に落とす"}, -- The Jar
    {"291", "ジャー", "全ての雑魚敵がうんちに変化#うんちタイプのボスが即死"}, -- Flush!
    {"292", "邪悪な聖書", "黒ハートを1個付与"}, -- Satanic Bible
    {"293", "クランプスの頭", "ブリムストーンビームを 十字方向に放つ#各ビームは最大440の ダメージを与える"}, -- Head of Krampus
    {"294", "バタービーンズ", "おならで近くの敵と弾を ノックバックさせる#他のアクティブアイテム との交換・再取得を繰り 返した時、10%の確率で {{Collectible484}}WaitWhat?に変化する"}, -- Butter Bean
    {"295", "マジックフィンガー", "1コイン消費し、部屋の 全ての敵に攻撃力ｘ2の ダメージを与える"}, -- Magic Fingers
    --NOTE FOR LOCALIZERS: There is code to highlight the text of your current floor
    --For it to work, only use line breaks or semicolons to separate floor details, and use the same order as English
    {"296", "コンバーター", "青／黒ハートを2個消費し、 最大体力を1個増やす"}, -- Converter
    {"297", "パンドラの箱", "使用フロアで効果が変化：#B1:青ハート 2個#B2:爆弾と鍵 各2個#C1:ボスアイテム 1個#C2:B1+C1#D1:青ハート 4個#D2:コイン 20枚#W1:ボスアイテム 2個#W2:{{Collectible33}} 聖書#???/Void:なし#Sheol:悪魔部屋アイテム1個 　　　黒ハート 1個#Cat:天使部屋アイテム 1個 　　白ハート 1個#DarkRoom:{{Collectible523}}お引越し用の箱をアンロック#Chest:コイン 1枚"}, -- Pandora's Box
    {"298", "ユニコーンの欠けた角", "6秒間、無敵状態になり 移動速度が0.28アップ するが、涙攻撃能力を 一時的に失う"}, -- Unicorn Stump
    {"299", "おうし座", "バトル中、移動速度が 徐々に増加する#速度が上限に達した時、 5秒間の無敵状態と 接触ダメージ効果を得る#↓ 移動速度 -0.3"}, -- Taurus
    {"300", "おひつじ座", "↑ 移動速度 +0.25#素早く敵に衝突すると 18のダメージを与える"}, -- Aries
    {"301", "かに座", "青ハート +3#同じ部屋で受ける2回目 以降のダメージが、 半ハートに軽減される"}, -- Cancer
    {"302", "しし座", "障害物破壊能力を付与#アイザックのサイズ拡大"}, -- Leo
    {"303", "おとめ座", "ダメージを受けた時、一定 確率でシールドを展開する#シールドは10秒間持続し、 全てのダメージを無効化#悪性のピルを良性に変換"}, -- Virgo
    {"304", "てんびん座", "コイン・鍵・爆弾 +6#取得時およびステータス 変動時に、各ステータス が平均化される"}, -- Libra
    {"305", "さそり座", "涙に毒効果を付与"}, -- Scorpio
    {"306", "いて座", "↑ 移動速度 +0.2#涙に貫通効果を付与"}, -- Sagittarius
    {"307", "やぎ座", "↑ 最大体力 +1#↑ 攻撃力　 +0.5#↑ 移動速度 +0.1#↑ 射程　　 +1.5#↑ 連射間隔 -1#コイン・鍵・爆弾 +1"}, -- Capricorn
    {"308", "みずがめ座", "アイザックの体から青い 液体が流れ続け、触れた 敵に毎秒6のダメージを 与える"}, -- Aquarius
    {"309", "うお座", "↑ 連射間隔 -1#↑ 涙サイズ +25%#ノックバック強化"}, -- Pisces
    {"310", "イブのマスカラ", "↑ 攻撃力　 +100%#↓ 連射速度 -50%#↓ 弾速　　 -0.5"}, -- Eve's Mascara
    {"311", "ユダの影", "{{Player12}} 死ぬと、一つ前の部屋に ダークユダとして復活#復活後、実績上はユダ として扱われる"}, -- Judas' Shadow
    {"312", "マギーのリボン", "↑ 最大体力 +1#体力を1回復#赤ハート取得時の回復量が 2倍になる"}, -- Maggy's Bow
    {"313", "聖なるマント", "部屋ごとに1回、最初に 受けたダメージを無効化 するシールドを付与する"}, -- Holy Mantle
    {"314", "ムッチムチなもも！", "↑ 最大体力 +1#↓ 移動速度 -0.4#障害物破壊能力を付与"}, -- Thunder Thighs
    {"315", "謎の引力", "涙が磁気を帯び、敵や ピックアップを引き寄せる"}, -- Strange Attractor
    {"316", "呪眼", "涙がチャージ式になり、  チャージ量に応じた数の 涙が連続発射される#!!! チャージ中にダメージを 受けると、ランダムな 部屋にテレポートする#{{Collectible260}} ブラックキャンドルを 所持している場合、 テレポートしない"}, -- Cursed Eye
    {"317", "謎の液体", "涙の衝突地点に緑色の 液体が残り、触れた敵に 毎秒30ダメージを与える"}, -- Mysterious Liquid
    {"318", "ふたご座", "アイザックと肉の鎖で つながれた使い魔が 敵を追いかけ攻撃し、 毎秒6ダメージを与える"}, -- Gemini
    {"319", "ケインの予備眼", "目玉が部屋を飛び回り、 アイザックと同じ涙を 発射する"}, -- Cain's Other Eye
    {"320", "？？？唯一の友", "攻撃方向に連動して移動し、 毎秒37.5の接触ダメージを 与える使い魔"}, -- ???'s Only Friend
    {"321", "サムソンの鎖", "アイザックに鉄球付きの 鎖がつながり、鉄球が 敵に接触ダメージを与え、 弾をブロックする#毎秒10.7の接触ダメージ#鉄球は障害物を破壊する"}, -- Samson's Chains
    {"322", "モンゴベイビー", "他の使い魔の涙をコピー して攻撃する使い魔#コピー対象が居ない場合、 3.5 ダメージのノーマルな 涙で攻撃する"}, -- Mongo Baby
    {"323", "アイザックのナミダ", "8方向に涙を同時発射する#涙を発射するとチャージが 回復する"}, -- Isaac's Tears
    {"324", "未定義", "トレジャールーム・隠し 部屋・I AM ERROR部屋の いずれかにテレポート"}, -- Undefined
    {"325", "ハサミ", "分離した頭がその場に固定 され、3.5ダメージの涙を放つ#操作する体側からも 涙を発射できる"}, -- Scissors
    {"326", "生命の息吹", "使用ボタンを押し続けると チャージ量が徐々に減り、 空になった瞬間無敵状態に なる#チャージ量が空になった後 更にボタンを1秒以上押し 続けるとダメージを受ける"}, -- Breath of Life
    {"327", "ポラロイド", "ダメージを受け、残りの 体力が半赤ハート以下に なった時、シールドを展開#シールドは5秒間持続し、 全てのダメージを無効化"}, -- The Polaroid
    {"328", "ネガティブ", "ダメージを受け、残りの 体力が半赤ハート以下に なった時、ネクロノミコン 効果を発動する （全ての敵に40ダメージ）"}, -- The Negative
    {"329", "ルドチーボ・テクニック", "涙を発射する代わりに 浮遊する一つの涙を操作する"}, -- The Ludovico Technique
    {"330", "豆乳", "↑ 連射速度大幅アップ (連射間隔 /4) -2#↓ 攻撃力 -80%"}, -- Soy Milk
    {"331", "神の首", "↑ 攻撃力　 +0.5#↑ 射程　　 +1.2#↓ 連射速度 -0.3#↓ 弾速　　 -0.3#↑ 涙の高さ +0.8#涙がオーラを放ち、触れた 敵にダメージを与える#涙にホーミング効果を付与"}, -- Godhead
    {"332", "ラザラスのぼろきれ", "死ぬと、その部屋で ラザラスとして復活する"}, -- Lazarus' Rags
    {"333", "ザ マインド", "フルマッピング効果"}, -- The Mind
    {"334", "ザ ボディー", "↑ 最大体力 +3"}, -- The Body
    {"335", "ザ ソウル", "青ハート +2#敵や弾を跳ね返す オーラが付与される"}, -- The Soul
    {"336", "枯れタマネギ", "涙に貫通と透過効果を付与#↑ 射程　　 +0.25#↓ 弾速　　 -0.4#↓ 涙の高さ -0.5#↑ 涙サイズ +50%"}, -- Dead Onion
    {"337", "壊れた時計", "4部屋ごとに全ての敵を スロー状態にするが、 まれにスピードアップ 効果が発生する"}, -- Broken Watch
    {"338", "ブーメラン", "ブーメランを投げる#攻撃力ｘ2のダメージを 与え、2秒間石化させる#ピックアップを回収可能"}, -- The Boomerang
    {"339", "安全ピン", "↑ 射程　　 +5.25#↑ 弾速　　 +0.16#↑ 涙の高さ +0.5#黒ハート +1"}, -- Safety Pin
    {"340", "カフェインピル", "↑ 移動速度 +0.3#↑ アイザックのサイズ縮小#取得時、ランダムな ピルを1個スポーン"}, -- Caffeine Pill
    {"341", "破れた写真", "↑ 連射速度 +0.7#↑ 弾速　　 +0.16"}, -- Torn Photo
    {"342", "青い帽子", "↑ 最大体力 +1#↑ 連射速度 +0.7#↓ 弾速　　 -0.16"}, -- Blue Cap
    {"343", "留め具の鍵", "↑ 運 +1#青ハート +1#取得時、鍵を2個スポーン"}, -- Latch Key
    {"344", "紙マッチ", "黒ハート +1#取得時、爆弾を3個スポーン"}, -- Match Book
    {"345", "合成オイル", "↑ 攻撃力　 +1#↑ 射程　　 +5.25#↑ 涙の高さ +0.5"}, -- Synthoil
    {"346", "スナック", "↑ 最大体力 +1"}, -- A Snack
    {"347", "複視症状", "部屋の全てのアイテムと ピックアップを複製する"}, -- Diplopia
    {"348", "プラシーボ", "保持中のピルの効果を コピーして発動する"}, -- Placebo
    {"349", "木製硬貨", "56%の確率でランダムな コインを1枚スポーン"}, -- Wooden Nickel
    {"350", "有毒ショック", "バトル開始時、部屋の 全ての敵を毒状態にする#死んだ敵が緑色の液体を 残し、触れた敵に毎秒30 ダメージを与える"}, -- Toxic Shock
    {"351", "メガ豆", "部屋の全ての敵を数秒間 石化させる#近くの敵に5ダメージと 毒を与える#地割れを起こし、触れた 敵に10ダメージを与え、 障害物を破壊する"}, -- Mega Bean
    {"352", "ガラスの大砲", "残り体力を半ハートまで 減らし、敵と障害物を 貫通する大粒の涙を放つ#攻撃力ｘ10+10のダメージ"}, -- Glass Cannon
    {"353", "ボンバーボーイ", "爆弾 +5#爆弾の爆発範囲が 十字型に広がる"}, -- Bomber Boy
    {"354", "クラックジャックス", "↑ 最大体力 +1#取得時、ランダムな トリンケットを1個 スポーンする"}, -- Crack Jacks
    {"355", "ママのパール", "↑ 射程　　 +1.25#↑ 運　　　 +1#↑ 涙の高さ +0.5"}, -- Mom's Pearls
    {"356", "車のバッテリー", "アクティブアイテムの 効果が2倍になる"}, -- Car Battery
    {"357", "おともだちボックス", "使い魔のコピーを追加#使い魔が居ない場合、 {{Collectible113}}デーモンベイビーが 追加される#使用した部屋でのみ有効"}, -- Box of Friends
    {"358", "ザ ウィズ", "両目から同時に、斜め 外側に向かって涙が 発射されるようになる#涙に透過効果を付与"}, -- The Wiz
    {"359", "８インチ釘", "↑ 攻撃力 +1.5#ノックバック強化"}, -- 8 Inch Nails
    {"360", "インキュバス", "アイザックの涙をコピー して攻撃する使い魔"}, -- Incubus
    {"361", "運命からのごほうび", "アイザックの涙をコピー して攻撃する使い魔#連射速度は通常の 使い魔の半分"}, -- Fate's Reward
    {"362", "小さな収納箱", "部屋をクリアした時、 25%の確率でピックアップ、 10%の確率でトリンケットを スポーンする使い魔"}, -- Lil Chest
    {"363", "誓約の守護者", "天使がアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#毎秒105の接触ダメージ#一部屋で弾を10発ブロック すると、白ハートを落とす"}, -- Sworn Protector
    {"364", "トモダチゾーン", "白いハエがアイザックを 周回し、接触した敵に 毎秒45ダメージを与える"}, -- Friend Zone
    {"365", "ロスト フライ", "壁や障害物に沿って 移動する使い魔#毎秒105の接触ダメージ"}, -- Lost Fly
    {"366", "拡散ボム", "爆弾 +5#爆弾から2～4個の小さな 爆弾が分裂する"}, -- Scatter Bombs
    {"367", "ねちょねちょボム", "爆弾 +5#爆弾で敵を倒すと 青クモがスポーン#爆弾が敵にくっ付く"}, -- Sticky Bombs
    {"368", "流涙症", "同一方向に攻撃し続けると 連射速度が上昇していき、 最大200%アップする#攻撃の停止・方向変更で 連射速度がリセットされる"}, -- Epiphora
    {"369", "連続体", "↑ 射程　　 +2.25#↑ 涙の高さ +1.5#涙に透過効果を付与#涙が画面の端と端で ループするようになる"}, -- Continuum
    {"370", "Mr. ドリー", "↑ 連射速度 +0.7#↑ 射程　　 +5.25#↑ 涙の高さ +0.5#取得時、ランダムな ハートを3個スポーン"}, -- Mr. Dolly
    {"371", "塔の呪い", "ダメージを受けるたび 6個のトロル爆弾がスポーン#この効果で生成された トロル爆弾は爆弾強化 アイテムの特殊効果を 引き継ぐ"}, -- Curse of the Tower
    {"372", "充電済みベイビー", "バトル中、30秒おきに、#{{Blank}} \7 電池のスポーン#{{Blank}} \7 チャージの追加#{{Blank}} \7 敵を1.5秒間石化#{{Blank}} のいずれかを行う使い魔#電池とチャージ効果は 一部屋2回まで有効"}, -- Charged Baby
    {"373", "死者の目", "↑ 涙が敵に当たるたび 攻撃力 +25%（最大100%）#涙が外れると一定確率で 攻撃力がリセットされる"}, -- Dead Eye
    {"374", "聖なる光", "一定確率で聖なる涙が 発射され、衝突すると 近くの敵に光線が降り注ぐ#光線は攻撃力ｘ4の ダメージを与える#確率：運0=10%、9=50%"}, -- Holy Light
    {"375", "ホスト ハット", "爆発耐性を付与#踏み潰し・地割れ 攻撃を無効化#敵の弾を25%の確率で ブロックし、跳ね返す"}, -- Host Hat
    {"376", "商品補充", "お店で商品を購入すると 新しい商品が補充される#取得時、ランダムな ピックアップを3個 スポーンする"}, -- Restock
    {"377", "バースティングサック", "クモタイプの敵が中立に なり、接触でダメージを 受けなくなる"}, -- Bursting Sack
    {"378", "No. 2", "攻撃ボタンを3秒間押し 続けると、うんち爆弾が スポーンする"},
    {"379", "多瞳孔症", "↑ 涙サイズ +100%#涙に透過効果を付与"}, -- Pupula Duplex
    {"380", "ペイ・トゥー・プレイ", "コイン +5#鍵で開くタイプのドアが コインで開くドアに置き 換わる"}, -- Pay to Play
    {"381", "エデンのご加護", "↑ 連射速度 +0.7#次のゲームの開始時に ランダムなアイテムが 付与される"}, -- Eden's Blessing
    {"382", "フレンドリーボール", "モンスターを捕獲できる ボール#再使用すると捕獲された 敵がチャーム状態で現れる"}, -- Friendly Ball
    {"383", "涙デトネーター", "使用すると、発射済みの 全ての涙が6つに分裂する"}, -- Tear Detonator
    {"384", "リトル ガーディー", "攻撃に連動してチャージを 溜め、解放されると高速で 体当たりを始める使い魔#スピードに応じて、毎秒 5～90の接触ダメージを与える"}, -- Lil Gurdy
    {"385", "バンボ", "コインを拾い集める使い魔#6枚／12枚／24枚以上 集めるたびに進化する：#{{Blank}} LV2：部屋クリア時、時々 　　 アイテムを落とす LV3：コインを落とす涙で 　　 攻撃する LV4：敵を追いかけて攻撃 　　 時々爆弾を投げる 　　 コインをランダムな 　　 アイテムに変換する"}, -- Bumbo
    {"386", "D12", "障害物をリロールする"},
    {"387", "香炉", "敵と弾をスロー状態にする オーラを放つ使い魔"}, -- Censer
    {"388", "キー バム", "鍵を拾ってランダムな 宝箱に変換する使い魔"}, -- Key Bum
    {"389", "ルーン袋", "5～6部屋クリアするたび ランダムなルーンを1個 スポーンする使い魔"}, -- Rune Bag
    {"390", "セラフィム", "10ダメージのホーミング効果 付き涙で攻撃する使い魔"}, -- Seraphim
    {"391", "裏切り", "ダメージを受けるたび 部屋の全ての敵を チャーム状態にする"}, -- Betrayal
    {"392", "ゾディアック", "毎フロア、ランダムな 星座アイテムの効果を 一つ付与する"}, -- Zodiac
    {"393", "サーペントのくちづけ", "15%の確率で涙に毒効果が 付与される#接触した敵に毒を与える#毒を受けた敵が死んだ時、 20%の確率で黒ハートを 落とす"}, -- Serpent's Kiss
    {"394", "照準マーク", "照準方向へ涙が自動で 流れ続けるようになる#照準は攻撃ボタンで操作#↑ 連射速度 +0.7#↑ 射程　　 +3.15#↑ 涙の高さ +0.3"}, -- Marked
    {"395", "テックＸ", "涙がチャージ式のレーザー リングに置き換わる#チャージ量に応じて リングのサイズが拡大"}, -- Tech X
    {"396", "心臓メス", "青色／オレンジ色の ポータルを足元に生成し、 双方をテレポートできる"}, -- Ventricle Razor
    {"397", "トラクタービーム", "アイザックの頭から放射 されるビームに沿って 涙が直進するようになる#↑ 連射速度 +0.5#↑ 射程　　 +5.25#↑ 弾速　　 +0.16#↑ 涙の高さ +0.5"}, -- Tractor Beam
    {"398", "神々の肉", "10%の確率で涙に収縮化 効果が付与される#収縮した敵は踏み潰して 倒せる"}, -- God's Flesh
    {"399", "モー オブ ザ ボイド", "↑ 攻撃力 +1#攻撃ボタンを押し続けて 2.35秒経過すると、頭に 十字架が浮かぶ 攻撃ボタンを解放すると ブリムストーンリングを 放出し、敵にダメージを 与える#この効果で敵を倒すと、 5%の確率で黒ハートを スポーンする"}, -- Maw of the Void
    {"400", "因縁のスピア", "アイザックの正面に 槍が現れる#槍は敵に攻撃力ｘ2の ダメージを与え、時々 恐怖状態にする"}, -- Spear of Destiny
    {"401", "エクスプロシボ", "25%の確率で涙が敵に くっ付き、数秒後に爆発#爆発は攻撃力+60の ダメージを与える#くっ付いた涙は敵に ダメージを与えない"}, -- Explosivo
    {"402", "カオス", "アイテムがランダムな アイテムプールから スポーンするようになる#取得時、ランダムな ピックアップを1～6個 スポーンする"}, -- Chaos
    {"403", "スパイダーＭＯＤ", "ダメージ量の数値と敵の 体力バーを表示する#機械のクモが部屋を歩き 回り、接触した敵に状態 異常を与える#部屋クリア時、青クモや 電池を時々スポーンする"}, -- Spider Mod
    {"404", "ファーティング ベイビー", "敵の弾をブロックする 使い魔　　#ブロックすると10%の 確率でおならを出し、 毒・ノックバック・ チャームのいずれかの 効果を敵に与える"}, -- Farting Baby
    {"405", "ＧＢバグ", "部屋を飛び回る使い魔#接触した敵に毎秒120の ダメージとランダムな 状態異常を与える#バトル中、ルート上の ピックアップ等を稀に リロールする"}, -- GB Bug
    {"406", "D8", "攻撃力・連射速度・射程・ 移動速度のステータスを リロールする"},
    {"407", "純潔", "ステータスを強化する オーラを付与#オーラの色と強化対象： {{ColorRed}}赤{{CR}}：攻撃力　 +4 {{ColorBlue}}青{{CR}}：連射速度 +2 {{ColorYellow}}黄{{CR}}：移動速度 +0.5 {{ColorOrange}}橙{{CR}}：射程　　 +7.5#ダメージを受けると オーラは消えるが、 部屋を移動すると ランダムな色で復活する"}, -- Purity
    {"408", "儀式の刃", "ダメージを受けると ブリムストーンリングを 放出し、敵にダメージを 与える#この効果で敵を倒すと、 15%の確率で黒ハートを スポーンする"}, -- Athame
    {"409", "からっぽの器", "黒ハート +2#赤ハートが無い時：#飛行能力を付与#バトル中、40秒おきに シールドを展開し、 ダメージを無効化する"}, -- Empty Vessel
    {"410", "邪眼", "攻撃中、低確率で目玉が 発射される#目玉はゆっくりと飛び、 アイザックと同じ涙を 発射する"}, -- Evil Eye
    {"411", "頑健ブラッド", "↑ 敵を倒すたび　　　　　　 攻撃力 +0.5（最大 +5）#その部屋でのみ有効"}, -- Lusty Blood
    {"412", "忌血の胎児", "一定回数のダメージを 受けると、悪魔タイプの 使い魔が永続付与される#最大4体まで付与され、 1／2体目は15回、 3／4体目は30回の ダメージを要する"}, -- Cambion Conception
    {"413", "純血の胎児", "ハートを15個拾うと、天使 タイプの使い魔が永続付与 され、同時に、青ハートが 1個スポーンする#使い魔は最大5体まで付与#使い魔が上限に達しても、 青ハートはスポーンする"}, -- Immaculate Conception
    {"414", "オプションおかわり", "トレジャールームの アイテムを2つの候補 から選択できる"}, -- More Options
    {"415", "光の冠", "青ハート +2#空の赤ハートが無い時：#↑ 攻撃力 +100%#↑ 射程　 +5.25#↓ 弾速　 -0.3 王冠が青く輝き、涙が ダイヤに置き換わる#ダメージを受けると、 その部屋では効果が 無効になる"}, -- Crown of Light
    {"416", "深いポケット", "カード・ルーン・ピルを 2つまで保持可能になる"}, -- Deep Pockets
    {"417", "サキュバス", "オーラを放ちながら 部屋を飛び回る使い魔#オーラ内では攻撃力が 50%アップする#オーラは範囲内の敵に 攻撃力ｘ1.29ダメージ を毎秒与える"}, -- Succubus
    {"418", "フルーツケーキ", "涙にランダムな 特殊効果を付与"}, -- Fruit Cake
    {"419", "テレポート２．０", "未探索のランダムな 部屋にテレポートする#優先順位: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}{{BossRushRoom}}>{{IsaacsRoom}}{{BarrenRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}>{{ErrorRoom}}"}, -- Teleport 2.0
    {"420", "黒い粉", "円を描くように歩くと 床に五芒星のシンボルが 浮かび上がり、範囲内の 敵に毎秒25のダメージを 与える"}, -- Black Powder
    {"421", "インゲン豆", "おならで近くの敵に 5ダメージを与え、 チャーム状態にする"}, -- Kidney Bean
    {"422", "輝く砂時計", "時間を巻き戻し、一つ 前の部屋に、一つ前の 部屋の状態で戻る"}, -- Glowing Hour Glass
    {"423", "守護の輪", "光輪がアイザックを囲み、 範囲内の敵に攻撃力と 等しいダメージを毎秒 与える#光輪は敵の弾を30%の 確率で跳ね返す#跳ね返された涙は アイザックの攻撃力と ホーミング効果を持つ"}, -- Circle of Protection
    {"424", "フクロ頭", "ピックアップが一定確率で サックに置き換わる#コイン：10%#その他：20%#取得時にサックを1袋 スポーンする"}, -- Sack Head
    {"425", "常夜灯", "アイザックの正面が ライトで照らされ、 範囲内の敵と弾を スロー状態にする#フロアに闇の呪いが かかっている場合、 それを取り除く"}, -- Night Light
    {"426", "熱狂的ファン", "3秒遅れでアイザックを 追従する使い魔#接触した敵に毎秒30の ダメージを与える"}, -- Obsessed Fan
    {"427", "マインクラフター", "移動可能なTNTを設置する"}, -- Mine Crafter
    {"428", "パジャマ", "青ハート +4#体力全回復"}, -- PJs
    {"429", "キーパーの頭", "涙が敵に当たると、5%の 確率でコインがスポーン"}, -- Head of the Keeper
    {"430", "パパ　バエ", "1秒遅れでアイザックを 追従する使い魔#アイザックと同じ攻撃力の 涙を発射する"}, -- Papa Fly
    {"431", "多数次元ベイビー", "2秒遅れでアイザックを 追従する使い魔#アイザックと使い魔の 涙がこれを通過すると、 弾速・高さがアップし、 ダブルショット化する"}, -- Multidimensional Baby
    {"432", "キラキラボム", "爆弾 +5#爆発した爆弾が、25%の 確率でピックアップや トリンケットをスポーン#爆発した爆弾が、15%の 確率で敵にチャームを 付与する"}, -- Glitter Bombs
    {"433", "ぼくの影", "ダメージを受けるたび 全ての敵を恐怖状態にし、 友好的なチャージャーを スポーンする#チャージャーは毎秒10の 接触ダメージを与える"}, -- My Shadow
    {"434", "ハエの壺", "敵を倒すと、青ハエが ビンに追加される#最大20匹まで追加できる#アイテムを使用すると 青ハエを放出する"}, -- Jar of Flies
    {"435", "リトル ロキ", "3.5 ダメージの涙を十字 方向に発射する使い魔"}, -- Lil Loki
    {"436", "ミルク！", "ダメージを受けると 連射速度がアップする#その部屋でのみ有効"}, -- Milk!
    {"437", "D7", "その部屋で倒した敵を リスポーンする#クリア報酬のスポーン、 アクティブアイテムの チャージも再度有効化#!!! グリードが現れたお店・ 隠し部屋で使用すると、 通常のお店・隠し部屋 として復活する"},
    {"438", "おしゃぶりチクビ", "青ハート +1#↑ 連射速度 +0.75#↑ アイザックのサイズ縮小"}, -- Binky
    {"439", "ママの箱", "保持中、トリンケットの 効果が2倍＆運 +1#使用すると、ランダムな トリンケットをスポーン"}, -- Mom's Box
    {"440", "腎臓結石", "涙が時々詰まり、その 状態でチャージすると 顔がうっ血していく#フルチャージ状態で解放 すると結石が射出され、 連射速度が一時的に大幅 アップする#↓ 移動速度 -0.2#↓ 射程　　 -17#↑ 涙の高さ +2"}, -- Kidney Stone
    {"441", "メガブラスト", "メガサタンビームを 15秒間発射する#ビームは部屋やフロアを またいで持続する"}, -- Mega Blast
    {"442", "ダークプリンスの冠", "残りの赤ハートが ちょうど1個の時：#↑ 連射速度 +0.75#↑ 射程　　 +1.5#↑ 弾速　　 +0.2#有効時、王冠が赤く輝く"}, -- Dark Princes Crown (apostrophe added to the name in Repentance) -- Dark Prince's Crown
    {"443", "アップル！", "↑ 連射速度 +0.3#一定確率で涙がカミソリに 置き換わり、攻撃力ｘ4の ダメージを与える#確率：運0=6%、14=100%"}, -- Apple!
    {"444", "シャープペンシル", "15回に1回、涙の弾幕が 発射されるようになる#弾幕の涙は2倍の ダメージを与える"}, -- Lead Pencil
    {"445", "イヌの歯", "↑ 攻撃力　 +0.3#↑ 移動速度 +0.1#隠し部屋に隣接した 部屋に入ると、犬の 遠吠えが聞こえる#クロールスペースを 含む部屋に入ると、 犬の鳴き声が聞こえる"}, -- Dog Tooth
    {"446", "デッドトゥース", "攻撃中、アイザックが 毒のオーラを放ち、 触れた敵に毒を与える"}, -- Dead Tooth
    {"447", "リンガービーンズ", "7.5秒間攻撃を続けると、 おならの雲が発生し、 触れた敵に攻撃力ｘ5の ダメージを毎秒与える#雲は15秒間持続する#雲を涙で撃つと動かせる"}, -- Linger Bean
    {"448", "ガラスの破片", "ダメージを受けた時、 25%の確率で赤ハートを 1個スポーンし、 10%の確率で{{Collectible214}}貧血を 一時付与する"}, -- Shard of Glass
    {"449", "メタルプレート", "青ハート +1#敵の弾を25%の確率で 跳ね返す#跳ね返された涙は アイザックの涙を コピーし、混乱と ホーミング効果を持つ"}, -- Metal Plate
    {"450", "グリードの目", "20回に1回、涙と一緒に 金の涙が発射され、 コインを1枚消費する#金の涙は敵を黄金化し、 追加のダメージを与える#黄金化状態の敵を倒すと 1～4枚のコインが落ちる#コイン未所持の状態でも 金の涙は発射される"}, -- Eye of Greed
    {"451", "タロットクロス", "カード・ルーンに 追加の効果を付与する#取得時、ランダムな カード・ルーンを1個 スポーンする"}, -- Tarot Cloth
    {"452", "静脈瘤", "ダメージを受けると、 円形に10発の涙が発射 され、{{Collectible214}}貧血の効果が 一時的に付与される#10発の涙は25の追加 ダメージを持つ"}, -- Varicose Veins
    {"453", "複雑骨折", "↑ 射程　　 +1.5#↑ 涙の高さ +1#涙が骨に置き換わり、 衝突すると破片が散る#破片はダメージが半減する"}, -- Compound Fracture
    {"454", "多指", "カード・ルーン・ピルを 2つまで保持可能になる#取得時、ランダムな カード・ルーン・ピルを 1つスポーンする"}, -- Polydactyly
    {"455", "パパが失くしたコイン", "↑ 射程　　 +1.5#↑ 涙の高さ +1#取得時、ラッキーペニーを 1枚スポーン"}, -- Dad's Lost Coin
    {"456", "カビの生えたパン", "↑ 最大体力 +1"}, -- Moldy Bread
    {"457", "コーンあたま", "青ハート +1#20%の確率でダメージを 無効化する"}, -- Cone Head
    {"458", "へそ", "トリンケットを2個まで 保持可能になる#取得時、ランダムな トリンケットを1個 スポーンする"}, -- Belly Button
    {"459", "副鼻腔炎", "攻撃中、20%の確率で 鼻くそが発射され、 敵に60秒間くっ付く#鼻くそは攻撃力と等しい ダメージを毎秒与える"}, -- Sinus Infection
    {"460", "緑内障", "5%の確率で涙に 混乱効果を付与#ゲーム画面が暗くなる"}, -- Glaucoma
    {"461", "寄生虫", "一定確率で涙が卵に置き  換わり、敵に当たると、  1～2匹の青クモ／ハエが  スポーンする#卵の衝突地点に白い液体が 広がり、触れた敵をスロー 状態にする#確率：運0=15%、5=50%"}, -- Parasitoid
    {"462", "ベリアルの目", "↑ 射程　　 +1.5#↑ 涙の高さ +1#涙に貫通効果を付与#敵を貫通した後の涙は ダメージが2倍になり、 サイズが1.3倍広がり、 ホーミング効果が付与 される"}, -- Eye of Belial
    {"463", "硫酸", "↑ 攻撃力 +0.3#25%の確率で酸の涙を 発射し、障害物や壁、 ドアを破壊する"}, -- Sulfuric Acid
    {"464", "バランスのグリフ", "青ハート +2#チャンピオンタイプの 敵を倒した時の報酬が、 現在不足している物を 優先してスポーンする ように変更される"}, -- Glyph of Balance
    {"465", "アナログスティック", "↑ 連射速度 +0.3#涙を斜めに発射できる"}, -- Analog Stick
    {"466", "感染", "部屋で最初に倒された 敵が毒ガスを放出し、 近くの敵に毒を与える#この毒効果で倒された 敵も毒ガスを放出し、 効果が連鎖する"}, -- Contagion
    {"467", "フィンガー！", "アイザックの攻撃方向に 指が現れ、直線上の敵に 攻撃力x0.1のダメージを 毎秒10回与える"}, -- Finger!
    {"468", "シェード", "1秒遅れでアイザックを 追従する使い魔#接触した敵に毎秒30の ダメージを与える#合計600ダメージを 与えると消滅し、 アイザックに同等の 接触ダメージ効果を 付与する"}, -- Shade
    {"469", "うつ", "敵にダメージを与える 液体を床に流しながら アイザックを追従する 使い魔#液体は毎秒6ダメージを 与える　#雲に敵が触れた時、低い 確率で{{Collectible374}}聖なる光による 光線攻撃が発生する"}, -- Depression
    {"470", "ハッシー", "部屋を飛び回る使い魔#接触した敵に毎秒30の ダメージを与える#攻撃ボタン押下中は 移動を停止する"}, -- Hushy
    {"471", "リトルモンストロ", "チャージ式の弾幕涙で 攻撃する使い魔#涙は一発3.5ダメージ"}, -- Lil Monstro
    {"472", "キングベイビー", "使い魔の先頭に固定 され、他の使い魔を 従える使い魔#攻撃ボタン押下中、 他の使い魔と共に その場で停止し、 離すと戻ってくる"}, -- King Baby
    {"473", "ビッグ チャビー", "涙の発射方向に連動して ゆっくり突進する使い魔#毎秒40.5の接触ダメージ#突進中、敵の弾をブロック"}, -- Big Chubby
    {"474", "扁桃腺", "敵の弾をブロックする"}, -- Tonsil
    {"475", "プランＣ", "全ての敵に9,999,999の ダメージを与え、3秒後に アイザックを殺す"}, -- Plan C
    {"476", "D1", "ピックアップをランダムに 1個複製する"},
    {"477", "ボイド", "!!! 部屋の全てのアイテムを 破壊して吸収する#アクティブアイテムを 吸収すると、ボイド 使用時にその効果を 同時発動する#パッシブアイテムを吸収 すると、ステータスが ランダムに2つアップ"}, -- Void
    {"478", "一時停止", "攻撃ボタンが押される まで、全ての敵を停止する#ボスは30秒経過すると 行動を再開する"}, -- Pause
    {"479", "スメルター", "保持中のトリンケットを 吸収し、効果を永続化する#保持中、トリンケットの 出現率がアップ"}, -- Smelter
    {"480", "コンポスト", "部屋内のピックアップを 青ハエ／クモに変換する#保有する青ハエ／クモの 量を倍にする#保有する青ハエ／クモが 無い場合、どちらかを 1匹スポーン"}, -- Compost
    {"481", "データマイナー", "ランダムなステータスを 一つ増やし、一つ減らす#その部屋に居る間、涙に ランダムな効果を付与#画面と音楽を歪める"}, -- Dataminer
    {"482", "クリッカー", "ランダムなプレイヤー キャラクターに変化し、 最後に取得した アイテムを削除する"}, -- Clicker
    {"483", "マ・マ・メガ！", "部屋の全ての障害物を 破壊し、全ての敵に 200ダメージを与える#効果はフロア全体で発動#ボスラッシュ・ハッシュ・ 隠し部屋の入り口も破壊#!!! 金爆弾を所持している時、 ママメガ！の代わりに それを消費して効果を 発動できる"}, -- Mama Mega!
    {"484", "え、ん、なんて？", "敵と弾をノックバックし、 周囲に地割れを起こす#地割れは障害物やドア、 隠し部屋の壁を破壊する"}, -- Wait What?
    {"485", "曲がったペニー", "部屋の全てのアイテム・ ピックアップ・宝箱を、 50/50の確率で2倍か、 消滅かさせる#消滅した場合コインを 1枚スポーンする"}, -- Crooked Penny
    {"486", "切れ味の鈍いカミソリ", "体力を奪うことなく アイザックを傷つけ、 ダメージをトリガーに するアイテムの効果を 有効化する"}, -- Dull Razor
    {"487", "ポテトピーラー", "使用するたび：#↓ 最大体力 -1#↑ 攻撃力 +0.2#{{Collectible73}} 肉の塊を付与#{{Collectible214}} 貧血の効果がその部屋 でのみ有効化する （射程アップ＆流血）"}, -- Potato Peeler
    {"488", "メトロノーム", "ランダムなアイテム効果を その部屋に居る間付与"}, -- Metronome
    {"489", "Ｄインフィニティー", "使用するたびランダムな ダイス系アイテムに変化 する　　"}, -- D Infinity
    {"490", "エデンの魂", "現在の部屋のアイテム プールから、2つの ランダムなアイテムを スポーンする#初期チャージ量が空の ため、要チャージ"}, -- Eden's Soul
    {"491", "アシッドベイビー", "3部屋クリアごとに ランダムなピルを1個 スポーンする使い魔#ピル使用時、部屋の 全ての敵に毒を与える"}, -- Acid Baby
    {"492", "ＹＯ　開けｙｏ！", "↑ 運 +1#隠し部屋の入り口、ｘ岩、 クロールスペースの位置 を教えてくれる使い魔"}, -- YO LISTEN!
    {"493", "アドレナリン", "↑ 空の赤ハート1個につき 攻撃力 +0.2"}, -- Adrenaline
    {"494", "ヤコブのハシゴ", "涙が衝突した時、火花 放電が1～2回発生する#火花は攻撃力ｘ0.5の ダメージを与える"}, -- Jacob's Ladder
    {"495", "ゴーストペッパー", "攻撃中、一定確率で 赤い炎を放つ#炎は接触した敵に ダメージを与え、 弾をブロックする#接触／ブロックを 4回行うと消滅する"}, -- Ghost Pepper
    {"496", "安楽死", "一定確率で涙が注射針に 置き換わる#注射針は敵を即死させ、 円形に10発の涙を拡散する#ボスには攻撃力ｘ3の ダメージを与える#確率：運0=3%、15=100%"}, -- Euthanasia
    {"497", "カモフラパンツ", "部屋に入った時、攻撃 ボタンを押すまでの間 アイザックを透明化し、 全ての敵を混乱させる"}, -- Camo Undies
    {"498", "二重性", "悪魔部屋か天使部屋が 出現する時、もう一方の 部屋も同時に出現する#一方の部屋に入ると、もう 一方の部屋は消滅する"}, -- Duality
    {"499", "エウカリスト", "天使部屋の出現率を 100%にする#天使部屋のドアが 部屋を離れても 開いたままになる"}, -- Eucharist
    {"500", "袋の中の袋", "5～6部屋クリアするたび サックをスポーンする 使い魔"}, -- Sack of Sacks
    {"501", "グリードの喉", "所持コイン25枚ごとに 最大体力を1増やす#99枚で最大+4#キーパーにも適用可能"}, -- Greed's Gullet
    {"502", "大きなニキビ", "攻撃中、低確率で 皮脂の弾が発射される#ダメージを受けた時、 ランダムな方向に 皮脂の弾を発射する#皮脂は倍のダメージを与え、 敵をスロー状態にし、床に スロー効果の粘液を残す"}, -- Large Zit
    {"503", "リトルホーン", "一定確率で涙に貫通効果が 付与され、触れた敵を即死 させる#確率：運0=5%、15=20%#アイザックに、毎秒7の 接触ダメージ効果を付与"}, -- Little Horn
    {"504", "ブラウンナゲット", "2ダメージの涙で近くの 敵を自動攻撃するハエを スポーンする"}, -- Brown Nugget
    {"505", "ポケＧＯ", "敵が居る部屋に入ると、 20%の確率でチャーム 状態の敵がスポーンする"}, -- Poke Go
    {"506", "裏切り者", "涙が敵の背面に当たると ダメージが2倍になり、 出血状態が付与される#出血中の敵は5秒ごとに 最大体力の10%に相当 するダメージを受ける"}, -- Backstabber
    {"507", "シャープストロー", "部屋の全ての敵に ダメージを与える#ダメージ量は攻撃力+ 敵の最大体力の10%分#この効果でダメージを 与えた時、15%の確率で 半赤ハートをスポーン#赤ハートの体力が無い 場合、半青ハートを スポーンする"}, -- Sharp Straw
    {"508", "ママのカミソリ", "アイザックを周回する カミソリの使い魔#カミソリは接触した敵に 攻撃力ｘ3のダメージを 毎秒与え、出血状態にする#出血中の敵は5秒ごとに 最大体力の10%に相当 するダメージを受ける#ボスには無効#弾のブロックはしない"}, -- Mom's Razor
    {"509", "充血した目", "アイザックを周回する 目玉の使い魔#接触した敵に毎秒30の ダメージを与える#2秒に1回、3.5ダメージの 涙を発射する"}, -- Bloodshot Eye
    {"510", "精神錯乱", "友好的なデリリアムを 召喚する#その部屋でのみ有効"}, -- Delirious
    {"511", "怒ったハエ", "ランダムな敵の周囲を 飛び回る使い魔#接触した敵に毎秒30の ダメージを与える#周回対象の敵が死ぬと、 別の敵を周回し始める#対象の敵が居ない時、 アイザックを周回する"}, -- Angry Fly
    {"512", "ブラックホール", "ブラックホールを生成し、 敵と弾、ピックアップを 6秒間吸引する#吸い込まれた敵に 毎秒6ダメージを与える#近くの障害物を破壊する"}, -- Black Hole
    {"513", "ボゾ", "↑ 攻撃力 +0.1#青ハート +1#敵をランダムに恐怖か チャーム状態にする#ダメージを受けた時、 5%の確率で虹色うんちを スポーンする"}, -- Bozo
    {"514", "壊れたモデム", "敵と弾がランダムな 間隔で遅延を起こす#25%の確率で部屋の クリア報酬が2倍になる"}, -- Broken Modem
    {"515", "ミステリーギフト", "現在の部屋のアイテム プールから、ランダムな アイテムを1つスポーン#低確率で{{Collectible132}}炭の塊か {{Collectible36}}うんちがスポーンする"}, -- Mystery Gift
    {"516", "スプリンクラー", "八方向に涙を発射する 回転式スプリンクラー#スプリンクラーは アイザックの涙を コピーして発射する"}, -- Sprinkler
    {"517", "ファスト ボム", "爆弾 +7#爆弾を高速で連続設置 可能になる"}, -- Fast Bombs
    {"518", "箱の中のバディー", "ランダムな特殊効果・ 攻撃力・連射速度の 涙で攻撃する使い魔#毎フロア、ランダムな 形態へ変化する"}, -- Buddy in a Box
    {"519", "リトルデリリアム", "10秒ごとにランダムな 使い魔に変身する使い魔"}, -- Lil Delirium
    {"520", "ブースターケーブル", "敵を15体倒すたびに アクティブアイテムを 1チャージする"}, -- Jumper Cables
    {"521", "クーポン", "お店の商品・悪魔部屋の アイテムをランダムに 一つ無料にする#保持中、お店の商品が ランダムに一つ半額化"}, -- Coupon
    {"522", "テレキネシス", "使用後3秒間、敵の弾が アイザックの周囲で一時 停止し、固定される#3秒経過すると弾が跳ね 返され、3.5ダメージを 与える"}, -- Telekinesis
    {"523", "お引越し用の箱", "部屋の全てのアイテムと ピックアップを保存して 運べる#保存した状態で再使用 すると、中身をその場で 展開する"}, -- Moving Box
    {"524", "テクノロジーゼロ", "涙同士が電気ビームで つながり、触れた敵に ダメージを与える#電気ビームは攻撃力と 等しいダメージを与える"}, -- Technology Zero
    {"525", "レプロシー", "ダメージを受けると 肉片がスポーンし、 アイザックを周回する#肉片は接触した敵に 毎秒35のダメージを与え、 弾をブロックする#肉片は一定量の接触・ ブロックで破壊される#最大3つまでスポーン"}, -- Leprosy
    {"526", "７つの封印", "10秒ごとにランダムな ハービンガーに変化する 使い魔#敵に接触ダメージを与え、 イナゴをスポーンする"}, -- 7 Seals
    {"527", "ミスターボク！", "!!! 照準を合わせた対象に 応じて効果が変化する#アイテムなど：拾って アイザックの元へ運ぶ#お店・悪魔部屋：50%の 確率でアイテムを盗む#宝箱・ドア：鍵や爆弾を 消費せずに開く#敵：追いかけ攻撃する#破壊可能なもの：爆破"}, -- Mr. ME!
    {"528", "エンジェリック プリズム", "プリズムがアイザックを 周回し、涙がそれを通過 すると、四色の涙に分裂 して発射される#使い魔の涙にも有効"}, -- Angelic Prism
    {"529", "ポロッ！", "涙を目玉に置き変える#目玉はビリヤード玉の ように互いを弾き合う"}, -- Pop!
    {"530", "死神のリスト", "敵を指定の順番で倒すと、 ランダムな報酬を得る#順番は{{BossRoom}}で示される#報酬のリスト：#青ハート・ピル・ 鍵・爆弾・ニッケル いずれかをスポーン#移動速度・連射速度・ 攻撃力・射程・弾速・ 運いずれかがアップ"}, -- Death's List
    {"531", "流血", "涙が弧を描いて飛び、 衝突すると破裂して 小さな涙が拡散する#↓ 連射速度#↑ 攻撃力　 +31%"}, -- Haemolacria
    {"532", "涙ごっくん", "涙が徐々に減速しながら 飛ぶようになり、停止か 衝突すると破裂して涙を 拡散する#涙が他の涙を吸収し、 サイズとダメージを 増加させるようになる#涙が5つ吸収されると、 即座に破裂する"}, -- Lachryphagy
    {"533", "聖三祝文", "涙が貫通効果を持つ 短い光線に置き換わる#光線は攻撃力ｘ0.33の ダメージを複数回与える"}, -- Trisagion
    {"534", "スクール バッグ", "アクティブアイテムを 2つ保持可能になる#ドロップボタンで切替え"}, -- Schoolbag
    {"535", "もうふ", "青ハート +1#体力を1回復#ボス部屋に入った時、 一度だけダメージを 無効化するシールドを付与"}, -- Blanket
    {"536", "いけにえの祭壇", "使い魔をランダムに最大 2体生贄に捧げ、等しい 数の悪魔部屋アイテムを スポーンする#所有する青ハエ／クモが コインに変換される"}, -- Sacrificial Altar
    {"537", "リトルゲロゲロ", "アイザックの攻撃に連動 してチャージを溜め、 解放時に有害な液体を 床に吐き出す使い魔#ピルを使用するたびに 液体の効果がランダムに 変化する#取得時、ランダムな ピルを1個スポーン"}, -- Lil Spewer
    {"538", "ビー玉", "取得時、ランダムな トリンケットを3つ スポーンする#ダメージを受けた時、 10%の確率で保持中の トリンケットが吸収 され、効果が永続化する"}, -- Marbles
    {"539", "ミステリーエッグ", "ダメージを受けると チャーム状態の敵が スポーンする#ノーダメージクリアした 部屋の数が多いほど、 強い敵がスポーンする"}, -- Mystery Egg
    {"540", "フラットストーン", "涙が床を跳ねながら 飛ぶようになる#涙が跳ねると飛沫が飛び、 攻撃力ｘ0.25のダメージを 与える"}, -- Flat Stone
    {"541", "髄", "骨ハート +1#取得時、赤ハートを3個 スポーンする"}, -- Marrow
    {"542", "すべり肋骨", "骨がアイザックを周回し、 敵の弾を跳ね返す"}, -- Slipped Rib
    {"543", "神聖なる土", "ダメージを受けると 白いうんちがスポーン#うんちオーラの範囲内 では連射速度が増加し、 50%の確率でダメージが 無効化される"}, -- Hallowed Ground
    {"544", "トゲトゲあばら骨", "アイザックの正面に 骨が現れ、接触した 敵にダメージを与える#骨は攻撃力と等しい ダメージを毎秒6回 与える　　　"}, -- Pointy Rib
    {"545", "死者の本", "その部屋で倒された敵 1体につき、友好的な 骨タイプの敵、または アイザックを周回する 骨を1つスポーンする"}, -- Book of the Dead
    {"546", "パパのゆびわ", "アイザックを小さな 光輪が囲み、触れた 敵を石化させる"}, -- Dad's Ring
    {"547", "離婚届", "↑ 連射速度 +0.7#骨ハート +1#取得時、{{Trinket21}} 謎の紙を スポーンする"}, -- Divorce Papers
    {"548", "あご骨", "涙の発射方向に連動して 飛んでいく骨の使い魔#接触した敵に7ダメージを 与え、弾をブロックする#ピックアップを回収可能"}, -- Jaw Bone
    {"549", "脆弱骨", "最大体力を0にし、6個の 骨ハートに置き換える#骨ハートを失うと：#8方向に骨が飛び散る#↑ 連射速度 +0.5（永続）"}, -- Brittle Bones
    {"550", "壊れたシャベル", "保持中、数秒おきに アイザックを狙った 踏み潰し攻撃が発生する#使用すると、その部屋に 居る間、踏み潰し攻撃が 停止する#!!! 取得後、これを手放した 状態で部屋を離れると、 これは消滅する#!!! (ボスラッシュに挑戦！)"}, -- Broken Shovel
    {"551", "壊れたシャベル", "壊れたシャベルの先端部#組み合わせると ママのシャベルに"},
    {"552", "ママのシャベル", "次のフロアにつながる トラップドアを生成#10%の確率でクロール スペースにつながる#!!! ある場所で使うと…？"}, -- Mom's Shovel
}

---------- Modifiers ----------

-- Effect of Car battery on Active Items
EID.descriptions[languageCode].carBattery = {
	["No Effect"] = "効果なし",
	[35] = {"40ダメージ", "80ダメージ"}, -- Necronomicon
	[37] = {"爆弾を", "{{CR}}爆弾を{{BlinkYellowGreen}}2個{{CR}}"}, -- Mr. Boom
	[38] = {"10発", "20発"}, --Tammy's Head
	[45] = {"1個", "2個"}, -- Yum Heart
	[58] = {"10秒間", "20秒間"}, -- Book of Shadows
	[65] = {"6個", "12個"}, -- Anarchist Cookbook
	[66] = {"8秒間", "16秒間"}, -- The Hourglass
	[77] = {"6秒間", "12秒間"}, -- My Little Unicorn
	[78] = {"1個", "2個"}, -- Book of Revelations
	[83] = {"青ハートを{{BlinkYellowGreen}}2個{{CR}}付与する#↑ 攻撃力　 +1.4#↓ 移動速度 -0.18#毎秒40の接触ダメージ 効果を得る#障害物を破壊できる"}, -- The Nail
	[85] = {"1枚", "2枚"}, -- Deck of Cards
	[86] = {"120ダメージ", "240ダメージ"}, -- Monstro's Tooth
	[93] = {"6秒間", "12秒間"}, -- The Gamekid
	[97] = {"1個", "2個"}, -- The Book of Sin
	[102] = {"1個", "2個"}, --Mom's Bottle of Pills
	[105] = "二重リロールでアイテム プールの枯渇が加速", -- The D6
	[107] = "体が二つスポーンする", -- The Pinking Shears
	[111] = "ダメージ2倍", -- The Bean
	[123] = {"1体", "2体"}, -- Monster Manual
	[124] = {"ランダムなアクティブ アイテムの効果を{{BlinkYellowGreen}}2回{{CR}}発動"}, -- Dead Sea Scrolls
	[136] = {"敵を引きつけるデコイの 爆弾を{{BlinkYellowGreen}}2個{{CR}}設置する"}, -- Best Friend
	[145] = {"2～4匹","4～7匹"}, -- Guppy's Head
	[146] = {"1個", "2個"}, -- Prayer Card
	[158] = {"1個", "2個"}, -- Crystal Ball	
	[160] = {5, 10}, -- Crack the Sky
	[171] = {"10ダメージ", "20ダメージ"}, -- Spider Butt
	[283] = "二重リロールでアイテム プールの枯渇が加速するも、 変身の条件達成にはプラス", -- D100
	[284] = "二重リロールでアイテム プールの枯渇が加速するも、 変身の条件達成にはプラス", -- D4
	[286] = "2回発動する", -- Blank Card
	[287] = {"いずれかの効果を", "{{CR}}から{{BlinkYellowGreen}}二つ{{CR}}の効果を"}, -- Book of Secrets
	[288] = {"1～4匹", "2～8匹"}, -- Box of Spiders
	[292] = {"1個", "2個"}, -- Satanic Bible
	[293] = {440, 880}, -- Head of Krampus
	[294] = "ノックバック強化", -- Butter Bean
	[298] = {"6秒間", "12秒間"}, -- Unicorn Stump
	[348] = "2回発動する", --Placebo
	[349] = "2回発動する", -- Wooden Nickel
	[351] = "ダメージ2倍", -- Mega Bean
	[357] = "コピー数2倍", -- Box of Friends
	[383] = {"6つ", "36個"}, -- Tear Detonator
	[421] = "ダメージ2倍", -- Kidney Bean
	[427] = {"移動可能なTNTを {{BlinkYellowGreen}}2個{{CR}}設置する"}, -- Mine Crafter
	[439] = "2個スポーンする", -- Mom's Box
	[476] = {"1個", "2個"}, --D1
	[477] = "吸収したアイテムにも 2倍効果が適用される", -- Void
	[480] = "スポーン数2倍", -- Compost
	[481] = {"一つ", "二つ"}, -- Dataminer
	[482] = "2回変化し、2個削除する", -- Clicker
	[485] = "25%：4倍複製　 25%：複製後、複製元は消滅 50%：失敗", -- Crooked Penny
	[486] = "2回発動する", -- Dull Razor
	[488] = "2回発動する", -- Metronome
	[489] = "2回目の効果はランダム", -- D Infinity
	[504] = {"2ダメージの涙で近くの 敵に自動攻撃するハエを {{BlinkYellowGreen}}2匹{{CR}}スポーン"}, -- Brown Nugget
	[507] = "2回発動する", -- Sharp Straw
	[510] = {"友好的なデリリアムを {{BlinkYellowGreen}}2体{{CR}}召喚する#その部屋でのみ有効"}, -- Delirious
	[516] = "二つ設置する", -- Sprinker
	[521] = {"お店の商品・悪魔部屋の アイテムをランダムに {{BlinkYellowGreen}}二つ{{CR}}無料にする#保持中、お店の商品が ランダムに一つ半額化"}, -- Coupon
	[523] = "2回発動し、箱と部屋の 中身を 入れ替える", -- Moving Box
	[545] = "最大スポーン数8→16", -- Book of the Dead
	[550] = {"踏み潰し攻撃を {{BlinkYellowGreen}}二部屋{{CR}}の間停止する#チャレンジルーム・ ボスラッシュでは {{BlinkYellowGreen}}2ウェーブ{{CR}}間停止する"}, -- Broken Shovel
}

-- Effect of BFFS! on Familiars
EID.descriptions[languageCode].BFFSSynergies = {
	["No Effect"] = "{1}の効果なし",
	["5.100.8"] = {3.5, 7}, -- Brother Bobby
	["5.100.57"] = {75, 150}, -- Distant Admiration
	["5.100.67"] = {3.5, 7}, -- Sister Maggy
	["5.100.73"] = "ダメージ2倍", -- Cube of Meat
	["5.100.88"] = {52.5, 105}, -- Little Chubby
	["5.100.94"] = {"2", "1～2"}, -- Sack of Pennies
	["5.100.95"] = {3.5, 7}, -- Robo-Baby
	["5.100.96"] = {"3", "2～3"}, -- Little C.H.A.D.
	["5.100.98"] = {"5～6", "4～5"}, -- The Relic
	["5.100.99"] = {3.5, 7}, -- Little Gish
	["5.100.100"] = {3.5, 7}, -- Little Steven
	["5.100.107"] = {82.5, 165}, -- The Pinking Shears
	["5.100.112"] = {105, 210}, -- Guardian Angel
	["5.100.113"] = {3, 6}, -- Demon Baby
	["5.100.117"] = {4.3, 8.6}, -- Dead Bird
	["5.100.128"] = {30, 60}, -- Forever Alone
	["5.100.131"] = {"3", "2～3"}, -- Bomb Bag
	["5.100.144"] = {"3～4", "3"}, -- Bum Friend
	["5.100.155"] = {17, 34}, -- The Peeper
	["5.100.163"] = {3.5, 7}, -- Ghost Baby
	["5.100.167"] = {4, 8}, -- Harlequin Baby
	["5.100.170"] = {40, 80}, -- Daddy Longlegs
	["5.100.172"] = {225, 450}, -- Sacrificial Dagger
	["5.100.174"] = {"3～5", "6～10"}, -- Rainbow Baby
	["5.100.187"] = "ダメージ2倍", -- Guppy's Hairball
	["5.100.188"] = {3.5, 7, 7.5, 15}, -- Abel (includes Cain's Rep synergy)
	["5.100.206"] = {105, 210}, -- Guillotine
	["5.100.207"] = "ダメージ2倍", -- Ball of Bandages
	["5.100.264"] = {22.5, 45}, -- Smart Fly
	["5.100.266"] = "青クモを追加スポーン", -- Juicy Sack
	["5.100.267"] = {3.5, 7}, -- Robo-Baby 2.0
	["5.100.270"] = {3.2, 6.4}, -- Leech
	["5.100.271"] = {"5～6", "4～5"}, -- Mystery Sack
	["5.100.272"] = {60, 85}, -- BBF
	["5.100.273"] = {60, 85}, -- Bob's Brain
	["5.100.274"] = {75, 150}, -- Best Bud
	["5.100.275"] = {31.5, 63}, -- Lil Brimstone
	["5.100.277"] = {4, 8}, -- Lil Haunt
	["5.100.279"] = {8.57, 17.14}, -- Big Fan
	["5.100.318"] = {6, 12}, -- Gemini
	["5.100.319"] = {"ダメージ2倍"}, -- Cain's Other Eye
	["5.100.320"] = {37.5, 75}, -- ???'s Only Friend
	["5.100.321"] = {10.7, 21.4}, -- Samson's Chains
	["5.100.322"] = {3.5, 7}, -- Mongo Baby
	["5.100.325"] = {3.5, 7}, -- Scissors
	["5.100.360"] = "ダメージ2倍", -- Incubus
	["5.100.361"] = "ダメージ2倍", -- Fate's Reward
	["5.100.362"] = {25, 31, 10, 12.5}, -- Lil Chest
	["5.100.363"] = {105, 210}, -- Sworn Protector
	["5.100.364"] = {45, 90}, -- Friend Zone
	["5.100.365"] = {105, 210}, -- Lost Fly
	["5.100.372"] = "電池のスポーン確率アップ", -- Charged Baby
	["5.100.384"] = {"5～90", "10～180"}, -- Lil Gurdy
	["5.100.385"] = "ダメージ2倍", -- Bumbo
	["5.100.388"] = "宝箱のスポーン確率アップ", -- Key Bum
	["5.100.389"] = {"5～6", "4～5"}, -- Rune Bag
	["5.100.390"] = {10, 20}, -- Seraphim
	["5.100.403"] = "電池のスポーン確率アップ", -- Spider Mod
	["5.100.405"] = {120, 240}, -- GB Bug
	["5.100.417"] = "ダメージを与えるオーラの 範囲拡大（攻撃力アップの オーラ範囲は据え置き）", -- Succubus
	["5.100.426"] = {30, 60}, -- Obsessed Fan
	["5.100.430"] = "ダメージ2倍", -- Papa Fly
	["5.100.435"] = {3.5, 7}, -- Lil Loki
	["5.100.468"] = {30, 60}, -- Shade
	["5.100.470"] = {30, 60}, -- Hushy
	["5.100.471"] = {3.5, 7}, -- Lil Monstro
	["5.100.473"] = {40.5, 81}, -- Big Chubby
	["5.100.491"] = {"3", "2～3"}, -- Acid Baby
	["5.100.500"] = {"5～6", "4～5"}, -- Sack of Sacks
	["5.100.508"] = {3, 6}, -- Mom's Razor
	["5.100.509"] = {3.5, 7, 30, 60}, -- Bloodshot Eye
	["5.100.511"] = {30, 60}, -- Angry Fly
	["5.100.518"] = "ダメージ2倍", -- Buddy in a Box
	["5.100.519"] = "ダメージ2倍", -- Lil Delirium
	["5.100.525"] = {35, 70}, -- Leprosy
	["5.100.526"] = "接触ダメージ2倍", -- 7 Seals
	["5.100.537"] = "液体の範囲拡大のみ", -- Lil Spewer
	["5.100.539"] = "チャンピオンタイプの 敵が生まれる", -- Mystery Egg
	["5.100.544"] = {6, 12}, -- Pointy Rib
	["5.100.545"] = "周回する骨のダメージ2倍", -- Book of the Dead
	["5.100.548"] = {7, 14}, -- Jaw Bone
	
	["5.350.54"] = {3.5, 7}, --- Isaac's Head
	["5.350.57"] = {3.5, 7}, --- ???'s Soul
	["Lilith"] = "インキュバスのダメージ2倍", -- Incubus (for BFFS pedestal)
}

---------- Trinkets ----------

EID.descriptions[languageCode].trinkets={
    {"1", "飲み込んだペニー", "ダメージを受けた時 コインを1枚スポーン"}, -- Swallowed Penny
    {"2", "固まったうんち", "うんち破壊時、50%の 確率でピックアップが スポーン"}, -- Petrified Poop
    {"3", "単４電池", "アクティブアイテムの 必要チャージ量が1減る"}, -- AAA Battery
    {"4", "壊れたリモコン", "アクティブアイテムを 使用した時、ランダム な部屋にテレポート"}, -- Broken Remote
    {"5", "パープルハート", "チャンピオンタイプの敵・ ボスの出現率2倍"}, -- Purple Heart
    {"6", "壊れた磁石", "コインがアイザックに 引き寄せられる"}, -- Broken Magnet
    {"7", "ロザリーのビーズ", "↑ 天使部屋の出現率 +25%#図書館とお店で{{Collectible33}}聖書の 出現率アップ"}, -- Rosary Bead
    {"8", "ゲームカセット", "ダメージを受けた時、一定 確率でゲームキッド効果が 発動（無敵・接触ダメージ）#確率：運0=5%、38=100%"}, -- Cartridge
    {"9", "パルスワーム", "涙が拡縮しながら飛ぶ"}, -- Pulse Worm
    {"10", "ウィグル ワーム", "涙が波打つように飛ぶ#↑ 連射速度 +0.4"}, -- Wiggle Worm
    {"11", "リング ワーム", "涙が渦巻き状に飛ぶ"}, -- Ring Worm
    {"12", "フラット ワーム", "涙の横幅が50%広がる#ノックバック強化"}, -- Flat Worm
    {"13", "商品券", "お店のアイテムが一つ無料 になり、取得すると消滅"}, -- Store Credit
    {"14", "たこ足", "トゲや液体などの、足元 からのダメージを無効化"}, -- Callus
    {"15", "ラッキー ロック", "岩や障害物を壊すと コインが1枚スポーン"}, -- Lucky Rock
    {"16", "ママの足のつめ", "60秒おきにランダムな 位置にママの踏み潰し 攻撃が発生する"}, -- Mom's Toenail
    {"17", "黒い口紅", "青ハートが黒ハートとして スポーンする確率 +10%"}, -- base chance is +5% -- Black Lipstick
    {"18", "よりぬき聖書", "白ハートの出現率 +3%"}, -- base chance is 1.667% -- Bible Tract
    {"19", "ペーパークリップ", "鍵を消費せずに鍵付きの 宝箱を解錠できる"}, -- Paper Clip
    {"20", "猿の手", "ダメージを受け、残りの 体力が半ハートになった 時、黒ハートを1個落とす#3回落とすと消滅"}, -- Monkey Paw
    {"21", "謎の紙", "{{Collectible327}} ポラロイド#{{Collectible328}} ネガティブ#{{Trinket23}} 尋ね人ポスター#{{Trinket48}} 失くしたページ いずれかの効果が ランダムに発動する"}, -- Mysterious Paper
    {"22", "悪魔の尻尾", "スポーンするハートの 80%が鍵に置き換わる#ハートは、可能な限り 黒ハートに置き換わる"}, -- Daemon's Tail
    {"23", "尋ね人ポスター", "{{Player10}} 死亡時、その部屋で ザ・ロストとして復活"}, -- Missing Poster
    {"24", "バット ペニー", "コインを拾うとおならが 出て、敵をノックバック させる　　　#うんちからコインが スポーンする確率 +20%"}, -- Butt Penny
    {"25", "謎のキャンデー", "30秒おきにうんちか おならを出す"}, -- Mysterious Candy
    {"26", "フックワーム", "涙が矩形波のように飛ぶ#↑ 射程 +10"}, -- Hook Worm
    {"27", "ウィップワーム", "↑ 弾速 +0.5"}, -- Whip Worm
    {"28", "壊れたアンク", "死ぬと、22.22%の確率で 一つ前の部屋に？？？と して復活する"}, -- Broken Ankh
    {"29", "魚の頭", "ダメージを受けるたび 青ハエがスポーンする"}, -- Fish Head
    {"30", "ピンキー アイ", "一定確率で毒の涙を放つ#確率：運0=10%、18=100%"}, -- Pinky Eye
    {"31", "画鋲", "一定確率で涙に貫通・ 透過効果を付与#確率：運0=10%、18=100%"}, -- Push Pin
    {"32", "リバティーキャップ", "部屋に入るたび、25%の 確率でいずれかの効果を 付与する：#{{Collectible71}} ミニ マッシュ#{{Collectible120}} 変なキノコ#{{Collectible121}} 変なキノコ#{{Collectible21}} コンパス"}, -- Liberty Cap
    {"33", "へそのお", "残りの体力が半赤ハートに なった時、その部屋に居る 間{{Collectible100}}リトルスティーブンを 付与する"}, -- Umbilical Cord
    {"34", "子供の心", "部屋クリア時の報酬が 10%の確率でハートに 置き換わる#宝箱・ｘ岩・破壊した 機械・殺した乞食から、 33%の確率でハートが 追加でスポーンする"}, -- Child's Heart
    {"35", "曲がった角", "↑ 攻撃力 +2"}, -- Curved Horn
    {"36", "さびたカギ", "部屋クリア時の報酬が 10%の確率で鍵に置き換わる#宝箱・ｘ岩・破壊した 機械・殺した乞食から、 33%の確率で鍵が追加で スポーンする"}, -- Rusted Key
    {"37", "ヤギのヒヅメ", "↑ 移動速度 +0.15"}, -- Goat Hoof
    {"38", "ママのパール", "青／黒／骨ハートの 出現率 +10%"}, -- base chance is 10% -- Mom's Pearl
    {"39", "癌", "↑ 連射間隔 -2"}, -- Cancer
    {"40", "赤いパッチ", "ダメージを受けた時、 一定確率で攻撃力 +1.8#確率：運0=20%、8=100%#効果はスタック可能で、 その部屋でのみ有効"}, -- Red Patch
    {"41", "マッチ棒", "部屋クリア時の報酬が 10%の確率で爆弾に 置き換わる#宝箱・ｘ岩・破壊した 機械・殺した乞食から、 33%の確率で爆弾が 追加でスポーンする#!!! {{Trinket53}}ダニを除去できる"}, -- Match Stick
    {"42", "幸運の足指", "↑ 運 +1#部屋クリア時の報酬 出現率が8%アップ#宝箱・ｘ岩・破壊した 機械・殺した乞食から、 33%の確率で追加の ピックアップがスポーン"}, -- Lucky Toe
    {"43", "呪いのしゃれこうべ", "ダメージを受け、残りの 体力が半ハートになると ランダムな部屋にテレポート"}, -- Cursed Skull
    {"44", "ボトルキャップ", "部屋クリア時の報酬が 10%の確率でピルに 置き換わる#宝箱・ｘ岩・破壊した 機械・殺した乞食から、 33%の確率でピルが 追加でスポーンする"}, -- Safety Cap
    {"45", "スペードのエース", "部屋クリア時の報酬が 10%の確率でカードに 置き換わる#宝箱・ｘ岩・破壊した 機械・殺した乞食から、 33%の確率でカードが 追加でスポーンする"}, -- Ace of Spades
    {"46", "アイザックのフォーク", "部屋クリア時、10%の 確率で半赤ハート回復#確率は運18で最大100%に"}, -- Isaac's Fork
    {"47", "", "<Item does not exist>"},
    {"48", "失くしたページ", "ダメージを受けた時、 ネクロノミコン効果が  一定確率で発動する （全ての敵に40ダメージ）#確率：運0=5%、60=50%"}, -- A Missing Page
    {"49", "血まみれのペニー", "コイン取得時、50%の確率で 半赤ハートをスポーン"}, -- Bloody Penny
    {"50", "燃え尽きたペニー", "コイン取得時、50%の 確率で爆弾をスポーン"}, -- Burnt Penny
    {"51", "平らなペニー", "コイン取得時、50%の 確率で鍵をスポーン"}, -- Flat Penny
    {"52", "偽造ペニー", "コイン取得時、50%の 確率で所持金が1増える"}, -- Counterfeit Penny
    {"53", "ダニ", "ボスを含む、HP60以上の 敵のHPを15%減少させる#ボス部屋に入った時、 赤ハート1個回復#!!! 取得すると取り外せない#{{Trinket41}} マッチ棒で除去可能"}, -- Tick
    {"54", "アイザックの頭", "3.5ダメージの貫通効果 付き涙で攻撃する、 追従型の使い魔を付与"}, -- Isaac's Head
    {"55", "マギーの信念", "フロア開始時、白ハートを 1個付与する"}, -- Maggy's Faith
    {"56", "ユダの舌", "悪魔取引のコストを 赤ハート1個に割り引く#{{Player4}} 青ハート3個の取引は、 ？？？使用時のみ 青ハート1個に割り引く"}, -- Judas' Tongue
    {"57", "？？？の魂", "部屋を飛び回り、透過と ホーミング効果を持つ 3.5ダメージの涙で攻撃 する使い魔を付与"}, -- ???'s Soul
    {"58", "サムソンの髷", "敵を倒した時、一定確率で 攻撃力 +0.5（最大 +5）#確率：運0=6.66%、10=100%#その部屋でのみ有効"}, -- Samson's Lock
    {"59", "ケインの目", "フロア開始時、一定確率で {{Collectible21}}コンパスの効果を付与#確率：運0=25%、3=100%"}, -- Cain's Eye
    {"60", "イブの鳥足", "敵を倒した時、一定確率で {{Collectible117}}鳥の死体が現れる#確率：運0=5%、8=100%"}, -- Eve's Bird Foot
    {"61", "左手", "全ての宝箱を赤宝箱に変換"}, -- The Left Hand
    {"62", "テカテカ石", "ｘ岩とクロールスペース 付きの岩が10秒おきに点滅"}, -- Shiny Rock
    {"63", "安全バサミ", "トロル爆弾が通常の爆弾 ピックアップに変化する"}, -- Safety Scissors
    {"64", "なないろワーム", "ランダムなワーム系の トリンケットの効果が 3秒おきに付与される"}, -- Rainbow Worm
    {"65", "さなだワーム", "↑ 射程　　 x2#涙の高さ -50%"}, -- Tape Worm
    {"66", "なまけワーム", "↓ 弾速　　 -0.4#↑ 射程　　 +4#↑ 涙の高さ +2"}, -- Lazy Worm
    {"67", "割れたダイス", "ダメージを受けた時、 D6／D8／D12／D20 いずれかの効果が 50%の確率で発動"}, -- Cracked Dice
    {"68", "スーパー磁石", "ピックアップと敵が アイザックに引き寄せ られるようになる"}, -- Super Magnet
    {"69", "消えかけインスタント写真", "アイザックが時々透明に なり、敵を混乱させる"}, -- Faded Polaroid
    {"70", "寄生虫", "バトル中、ランダムに 青クモがスポーンする"}, -- Louse
    {"71", "ボブの膀胱", "爆弾が置かれた場所に 緑色の液体が残り、 触れた敵にダメージを 与える"}, -- Bob's Bladder
    {"72", "時計の電池", "部屋クリア時の報酬に 電池が出現する確率 +6.66%#ランダムピックアップが 電池になる確率 +2%#部屋をクリアした時、 5%の確率でアクティブ アイテムが1チャージ"}, -- Watch Battery
    {"73", "キャップ飛ばし", "爆発した爆弾が10%の 確率で爆弾をスポーン"}, -- Blasting Cap
    {"74", "トゲトゲファインダー", "クロールスペースの 出現率が0.5%アップ"}, -- Stud Finder
    {"75", "エラー", "部屋ごとにランダムな トリンケットの効果を 付与する"}, -- Error
    {"76", "ポーカーチップ", "宝箱を開くと50%の確率で 追加の報酬がスポーンし、 50%の確率で中身がハエに 置き換わる"}, -- Poker Chip
    {"77", "水泡", "ノックバック強化"}, -- Blister
    {"78", "秒針", "敵に与える状態異常の 有効時間が2倍になる"}, -- Second Hand
    {"79", "エンドレスネームレス", "カード・ルーン・ピル 使用時、25%の確率で コピーをスポーンする"}, -- Endless Nameless
    {"80", "漆黒の羽根", "↑ 所持する悪魔タイプの アイテム・トリンケット 1個につき攻撃力 +0.2"}, -- Black Feather
    {"81", "見えない憤怒", "ダメージを受けた瞬間の 無敵時間を2倍にする"}, -- Blind Rage
    {"82", "金の蹄鉄", "保持して次のフロアに 移動した時、15%の確率で トレジャールームの アイテムが二択になる"}, -- Golden Horse Shoe
    {"83", "店の鍵", "鍵を使わずにお店へ 入ることができる"}, -- Store Key
    {"84", "強欲アバラ骨", "お店・隠し部屋で グリードが現れなくなる#部屋のクリア報酬に コインの出現率が増え、 ハートの出現率が減る"}, -- Rib of Greed
    {"85", "カルマ", "寄付マシーンへの寄付時、 33%の確率で以下の効果：#40%：赤ハートを1回復#40%：キャッシュバック#15%：運 +1#5%：乞食がスポーン"}, -- Karma
    {"86", "リトル幼虫", "うんちを壊すと青ハエが スポーンする"}, -- Lil Larva
    {"87", "ママのロケット", "鍵を使った時、半赤ハート 回復する#半赤ハートを赤ハートに 変換する"}, -- Mom's Locket
    {"88", "NO!", "保持中、アクティブ アイテムがスポーン しなくなる"},
    {"89", "子供用リード", "使い魔がアイザックに近付く"}, -- Child Leash
    {"90", "茶色いキャップ", "うんちを壊すと爆発する"}, -- Brown Cap
    {"91", "カニババ", "33%の確率で、うんちが 黒うんちに置き換わる#黒うんちから5%の確率で 黒ハートがスポーンする"}, -- Meconium
    {"92", "ひびが入った冠", "↑ アイテムやトリンケット からのステータス上昇値を 33%アップさせる#↑ 連射間隔 -20%"}, -- Cracked Crown
    {"93", "使用されたオムツ", "{{Collectible9}} 各部屋に15%の確率で スカトール効果を付与し、 ハエ系の敵を中立化する"}, -- Used Diaper
    {"94", "フィッシュテール", "青ハエ／イナゴをスポーン するタイプのトリンケット・ アイテムの効果を2倍にする"}, -- Fish Tail
    {"95", "黒い歯", "3%の確率で黒い歯が発射 され、2倍のダメージと 毒を与える#確率は運32で最大100%に"}, -- Black Tooth
    {"96", "ウロボロスワーム", "涙が渦を描くように飛ぶ#涙に透過効果を付与#↑ 射程　　 +4#↑ 涙の高さ +2"}, -- Ouroboros Worm
    {"97", "扁桃腺", "12～20回ダメージを 受けると、敵の弾を ブロックする使い魔が スポーンする#最大2体までスポーン"}, -- Tonsil
    {"98", "ノーズ ゴブリン", "10%の確率でホーミング 効果付きの鼻くそが飛び、 敵に 60秒間くっ付く#鼻くそは攻撃力と 等しいダメージを 毎秒与える"}, -- Nose Goblin
    {"99", "スーパーボール", "10%の確率で衝突した 涙が跳ね返る"}, -- Super Ball
    {"100", "明るい電球", "!!! アクティブアイテムが フルチャージの時：#↑ 攻撃力　 +0.5#↑ 移動速度 +0.25#↑ 射程　　 +0.75#↑ 連射速度 +0.2#↑ 弾速　　 +0.1#↑ 運　　　 +1"}, -- Vibrant Bulb
    {"101", "ほの暗い電球", "!!! アクティブアイテムの チャージが空の時：#↑ 攻撃力　 +1.5#↑ 移動速度 +0.5#↑ 射程　　 +1.5#↑ 連射速度 +0.4#↑ 弾速　　 +0.3#↑ 運　　　 +2"}, -- Dim Bulb
    {"102", "断片化されたカード", "保持して次のフロアへ 移動すると、追加の 隠し部屋が生成される"}, -- Fragmented Card
    {"103", "平等！", "コイン・爆弾・鍵の 所持数が等しい時、 各ピックアップが ダブルバージョンに 変換される"}, -- Equality!
    {"104", "ウィッシュボーン", "ダメージを受けた時 2%の確率でその部屋の アイテムプールから ランダムなアイテムを スポーンする#効果発動後に消滅する"}, -- Wish Bone
    {"105", "弁当袋", "ダメージを受けた時 2%の確率で{{Collectible22}}昼ごはんが スポーンする#効果発動後に消滅する"}, -- Bag Lunch
    {"106", "無くなったコルク", "アイテムや使い魔から 生成される液体の効果 範囲が広がる"}, -- Lost Cork
    {"107", "クロウハート", "ダメージを受ける時、 赤ハートが優先して 消費される　　"}, -- Crow Heart
    {"108", "クルミ", "爆発を受けた時、33%の 確率でトリンケット・ コイン・鍵・ハートを 1個ずつスポーンする#効果発動後に消滅する#爆発ダメージが無効化 されている状態でも発動"}, -- Walnut
    {"109", "ガムテープ", "このトリンケットを 取得した時の位置に 使い魔が固定される"}, -- Duct Tape
    {"110", "シルバーダラー", "保持して子宮／ユテロ／ 傷だらけの子宮フロアに 移動すると、お店が生成 される　　"}, -- Silver Dollar
    {"111", "血まみれな冠", "保持して子宮／ユテロ／ 傷だらけの子宮フロアに 移動すると、トレジャー ルームが生成される"}, -- Bloody Crown
    {"112", "勝つためにはコインをいれる", "保持して次のフロアへ移動 すると、トレジャールームに リロールマシーンが出現する"}, -- Pay to Win
    {"113", "戦争のセミ", "敵の居る部屋に入ると、 イナゴがスポーンする#イナゴは攻撃力x2の ダメージを与えた後 爆発する"}, -- Locust of War
    {"114", "疫病のセミ", "敵の居る部屋に入ると、 イナゴがスポーンする#イナゴは攻撃力x2の ダメージと毒を与える"}, -- Locust of Pestilence
    {"115", "飢饉のセミ", "敵の居る部屋に入ると、 イナゴがスポーンする#イナゴは攻撃力x2の ダメージを与え、 スロー状態にする"}, -- Locust of Famine
    {"116", "死のセミ", "敵の居る部屋に入ると、 イナゴがスポーンする#イナゴは攻撃力x4の ダメージを与える"}, -- Locust of Death
    {"117", "征服のセミ", "敵の居る部屋に入ると、 1～4匹のイナゴが スポーンする#イナゴは攻撃力x2の ダメージを与える"}, -- Locust of Conquest
    {"118", "コウモリの羽", "敵を倒すと、5%の確率で 飛行能力が付与される#その部屋でのみ有効"}, -- Bat Wing
    {"119", "幹細胞", "フロア移動時に半赤ハート 回復する"}, -- Stem Cell
    {"120", "ヘアピン", "ボス部屋に初めて入った時 アクティブアイテムをフル チャージする"}, -- Hairpin
    {"121", "木の十字架", "各フロアで一度だけ ダメージを無効にする"}, -- Wooden Cross
    {"122", "バター！", "アクティブアイテムを 使うと、足元にそれが ドロップされる#ダメージを受けた時、 2%の確率で取得済み パッシブアイテムが 足元にドロップされる"}, -- Butter!
    {"123", "フィリグリーな羽！", "天使を倒した時、カギの かけらの代わりに、 天使部屋のアイテムを スポーンする"}, -- Filigree Feather
    {"124", "扉止め", "入って来たドアが 開いたままになる"}, -- Door Stop
    {"125", "延長コード", "アイザックと使い魔の間に 電気ビームが発生し、敵に 6ダメージを与える"}, -- Extension Cord
    {"126", "腐ったペニー", "コインを拾うと青ハエが スポーンする"}, -- Rotten Penny
    {"127", "ベビーカーブ", "使い魔の涙にホーミング 効果が付与される"}, -- Baby-Bender
    {"128", "指のホネ", "ダメージを受けた時、2%の 確率で骨ハートを付与"}, -- Finger Bone
}

---------- Cards ----------

EID.descriptions[languageCode].cards={
    {"1", "0 - 愚者", "フロア開始時の部屋に テレポートする"}, -- The Fool
    {"2", "I - 魔術師", "その部屋に居る間、涙に ホーミング効果を付与"}, -- The Magician
    {"3", "II - 女教皇", "ママの踏み潰し攻撃で 敵に300ダメージ"}, -- The High Priestess
    {"4", "III - 女帝", "その部屋に居る間：#↑ 攻撃力　 +1.5#↑ 移動速度 +0.3"}, -- The Empress
    {"5", "IV - 皇帝", "ボス部屋にテレポート"}, -- The Emperor
    {"6", "V - 教皇", "青ハートを2個スポーン"}, -- The Hierophant
    {"7", "VI - 恋人", "赤ハートを2個スポーン"}, -- The Lovers
    {"8", "VII - 戦車", "無敵状態と接触ダメージ 効果を6秒間付与"}, -- The Chariot
    {"9", "VIII - 正義", "ハート・コイン・爆弾・ 鍵を各1個スポーン"}, -- Justice
    {"10", "IX - 隠者", "お店にテレポート"}, -- The Hermit
    {"11", "X - 運命の輪", "スロットマシーンか 占いマシーンをスポーン"}, -- Wheel of Fortune
    {"12", "XI - 力", "その部屋に居る間：#↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 攻撃力　 +50%#↑ 射程　　 +5.25#↑ 涙の高さ +0.5#↑ 移動速度 +0.3"}, -- Strength
    {"13", "XII - 吊られた男", "その部屋に居る間、 飛行能力を付与"}, -- The Hanged Man
    {"14", "XIII - 死神", "全ての敵に40ダメージ"}, -- Death
    {"15", "XIV - 節制", "献血機をスポーン"}, -- Temperance
    {"16", "XV - 悪魔", "その部屋に居る間：#↑ 攻撃力 +2"}, -- The Devil
    {"17", "XVI - 塔", "トロル爆弾を6個スポーン"}, -- The Tower
    {"18", "XVII - 星", "トレジャールームに テレポート"}, -- The Stars
    {"19", "XVIII - 月", "隠し部屋にテレポート"}, -- The Moon
    {"20", "XIX - 太陽", "全ての敵に100ダメージ#体力全回復#フルマッピング効果"}, -- The Sun
    {"21", "XX - 審判", "乞食か悪魔乞食をスポーン"}, -- Judgement
    {"22", "XXI - 世界", "フルマッピング効果"}, -- The World
    {"23", "クラブの２", "爆弾の所持数を2倍にする#未所持の場合+2個"}, -- 2 of Clubs
    {"24", "ダイヤの２", "所持金を2倍にする#未所持の場合+2枚"}, -- 2 of Diamonds
    {"25", "スペードの２", "鍵の所持数を2倍にする#未所持の場合+2個"}, -- 2 of Spades
    {"26", "ハートの２", "残り体力を2倍にする#体力が0の場合1回復"}, -- 2 of Hearts
    {"27", "クラブのエース", "全てのピックアップ・ 宝箱を爆弾に変換する"}, -- Ace of Clubs
    {"28", "ダイアのエース", "全てのピックアップ・ 宝箱をコインに変換する"}, -- Ace of Diamonds
    {"29", "スペードのエース", "全てのピックアップ・ 宝箱を鍵に変換する"}, -- Ace of Spades
    {"30", "ハートのエース", "全てのピックアップ・ 宝箱をハートに変換する"}, -- Ace of Hearts
    {"31", "ジョーカー", "悪魔部屋か天使部屋に テレポート"}, -- Joker
    {"32", "ハガラズ", "全ての障害物を破壊する"}, -- Hagalaz
    {"33", "ジェラ", "部屋の全ての宝箱と ピックアップを複製する"}, -- Jera
    {"34", "エワズ", "次のフロアにつながる トラップドアを生成#8%の確率でクロール スペースにつながる"}, -- Ehwaz
    {"35", "ダガズ", "青ハート +1#フロアの呪いを解く"}, -- Dagaz
    {"36", "アンスズ", "フルマッピング効果 （裏隠し部屋を含む）"}, -- Ansuz
    {"37", "ペースロ", "部屋の全てのアイテムを リロールする"}, -- Perthro
    {"38", "ベルカナ", "青ハエ／クモを3匹ずつ スポーンする"}, -- Berkano
    {"39", "アルギス", "ダメージを無効化する シールドを30秒間展開"}, -- Algiz
    {"40", "ブランクルーン", "ランダムなルーンの 効果を発動する#25%の確率でブランク ルーンをスポーンする"}, -- Blank Rune
    {"41", "ブラックルーン", "全ての敵に40ダメージ#全てのアイテムを破壊し、 ランダムなステータスを アップさせる#全てのピックアップを 青ハエ／クモに変換する"}, -- Black Rune
    {"42", "カオスのカード", "移動方向にカードを投げ、 触れた敵を即死させる#デリリウムは即死無効"}, -- Chaos Card
    {"43", "クレジットカード", "お店の商品／悪魔部屋の アイテムを全て無料にする"}, -- Credit Card
    {"44", "ルール カード", "やくだつじょうほうを表示"}, -- Rules Card
    {"45", "対人類カード", "部屋をうんちで埋め尽くす"}, -- A Card Against Humanity
    {"46", "自殺の王様", "アイザックを殺し、その 部屋に10個のアイテム・ ピックアップ・宝箱を スポーンする"}, -- Suicide King
    {"47", "刑務所釈放カード", "部屋の全てのドアと、 隠し部屋の入り口を開く"}, -- Get Out Of Jail Free Card
    {"48", "？カード", "現在保持中のアクティブ アイテムの効果をコピー する"}, -- ? Card
    {"49", "ダイスの破片", "部屋にある全てのアイテムと ピックアップをリロールする"}, -- Dice Shard
    {"50", "緊急連絡先", "ママの手が敵をつかんで 動きを止め、40ダメージ を与える"}, -- Emergency Contact
    {"51", "聖なるカード", "その部屋で次に受ける ダメージを一度だけ 無効化する#25%の確率で別の聖なる カードをスポーンする"}, -- Holy Card
    {"52", "巨大化", "その部屋に居る間：#↑ 攻撃力 +7#↑ 射程　 +30#障害物破壊能力を付与#アイザックのサイズ拡大"}, -- Huge Growth
    {"53", "古代のリコール", "ランダムなカードを 3枚スポーン"}, -- Ancient Recall
    {"54", "時代のウォーク", "その部屋に居る間：#全ての敵をスロー状態に#↑ 移動速度 +0.5#↓ 弾速　　 -1"}, -- Era Walk
}

--[[ Card Buffs caused by Tarot Cloth (separate table from Rep due to how different they are)
-- Strings will be appended to the original description (with line breaks replaced with a Tarot Cloth icon)
-- Tables with one entry will completely replace the original description
-- Tables with two or more entries are find-replace pairs (the new text will be colored Shiny Purple) ]]
EID.descriptions[languageCode].tarotClothBuffsAB = {
	[4] = {0.3, 0.6, 1.5, 3}, -- III - The Empress
	[6] = {2, 4}, -- V - The Hierophant
	[7] = {2, 4}, -- VI - The Lovers
	[8] = {6, 12}, -- VII - The Chariot
	[9] = {1, 2}, -- VIII - Justice
	[11] = {"スロットマシーンか 占いマシーンを{{ColorShinyPurple}}2つ{{CR}}スポーン"}, -- X - Wheel of Fortune
	[12] = {1, 2, 0.3, 0.6, 0.3, 0.6, 5.25, 10.5}, -- XI - Strength
	[14] = {40, 80}, -- XIII - Death
	[15] = {"献血機をスポーン", "{{CR}}献血機を{{ColorShinyPurple}}2つ{{CR}}スポーン", "悪魔乞食を1体スポーン", "{{CR}}悪魔乞食を{{ColorShinyPurple}}2体{{CR}}スポーン"}, -- XIV - Temperance (+ Greed version)
	[17] = {6, 12}, -- XVI - The Tower
	[20] = {100, 200}, -- XIX - The Sun
	[21] = {"スポーン", "{{ColorShinyPurple}}2体{{CR}}スポーン"}, -- XX - Judgement
	[23] = {"2倍", "4倍"}, -- 2 of Clubs
	[24] = {"2倍", "4倍"}, -- 2 of Diamonds
	[25] = {"2倍", "4倍"}, -- 2 of Spades
	[26] = {"2倍", "4倍"}, -- 2 of Hearts
	[33] = {"2倍", "4倍"}, -- Jera
	[35] = {1, 2}, -- Dagaz
	[37] = {"リロール", "{{ColorShinyPurple}}2回{{CR}}リロール"}, -- Perthro
	[38] = {3, 6}, -- Berkano
	[39] = {30, 60}, -- Algiz
	[40] = {"ランダムなルーンの 効果を{{ColorShinyPurple}}2回{{CR}}発動する#25%の確率でブランク ルーンをスポーンする （{{ColorShinyPurple}}2回{{CR}}抽選を行う）"}, -- Blank Rune
	[41] = {40, 80}, -- Black Rune
	[46] = {10, 20}, -- Suicide King
	[48] = "2回コピーする", -- ? Card
	[53] = {3, 6}, -- Ancient Recall
}

---------- Pills ----------

EID.descriptions[languageCode].unidentifiedPill = "未識別のピル"

EID.descriptions[languageCode].pills={
    {"0", "悪性ガス", "おならを放ちダメージと 毒を与える"}, -- Bad Gas
    {"1", "バッドトリップ", "ハート1個の ダメージを受ける#ハートが1個以下の場合、 体力全快ピルに変化"}, -- Bad Trip
    {"2", "鉄球", "青ハート +2"}, -- Balls of Steel
    {"3", "爆弾は鍵なり", "爆弾と鍵の所持数を 入れ替える"}, -- Bombs are Key
    {"4", "おなか急降下", "アイザックの尻から 点火済みの爆弾が 5連続スポーンする"}, -- Explosive Diarrhea
    {"5", "体力全快", "体力全回復"}, -- Full Health
    {"6", "ＨＰダウン", "↓ 最大体力 -1#最大体力が1以下の 場合、HPアップに変化"}, -- Health Down
    {"7", "ＨＰアップ", "↑ 最大体力 +1"}, -- Health Up
    {"8", "ピル発見", "効果なし"}, -- I Found Pills
    {"9", "厨二病", "3回使用すると大人になる （最大体力 +1）"}, -- Puberty
    {"10", "プリティー フライ", "アイザックを周回する ハエを付与する#最大3匹まで付与"}, -- Pretty Fly
    {"11", "射程距離ダウン", "↓ 射程 -2"}, -- Range Down
    {"12", "射程距離アップ", "↑ 射程 +2.5"}, -- Range Up
    {"13", "スピードダウン", "↓ 移動速度 -0.12"}, -- Speed Down
    {"14", "スピードアップ", "↑ 移動速度 +0.15"}, -- Speed Up
    {"15", "涙ダウン", "↓ 連射速度 -0.28"}, -- Tears Down
    {"16", "涙アップ", "↑ 連射速度 +0.35"}, -- Tears Up
    {"17", "運ダウン", "↓ 運 -1"}, -- Luck Down
    {"18", "運アップ", "↑ 運 +1"}, -- Luck Up
    {"19", "テレポピル", "ランダムな部屋に テレポートする#低確率でI AM ERRORへ"}, -- Telepills
    {"20", "４８時間戦えますか！", "アクティブアイテムを フルチャージする#1～2個の電池をスポーン"}, -- 48 Hour Energy!
    {"21", "吐血", "赤ハートを1個残しで 空にして、1～4個の 赤ハートをスポーン"}, -- Hematemesis
    {"22", "まひ", "2秒間のマヒ"}, -- Paralysis
    {"23", "あぁ刻が見える！", "現フロアの隠し部屋の 入り口を全て開放する"}, -- I can see forever!
    {"24", "フェロモン", "全ての敵をチャーム 状態にする"}, -- Pheromones
    {"25", "記憶喪失", "マップを？に置き換える (迷われし者の呪い)"}, -- Amnesia
    {"26", "レモンパーティー", "レモン汁が床に広がり、 触れた敵にダメージを 与える"}, -- Lemon Party
    {"27", "君、魔法使い？", "30秒間、涙が斜め外側に 飛ぶ"}, -- R U A Wizard?
    {"28", "強力鎮痛薬！", "その部屋に居る間、 受けるダメージを 半ハートに軽減する"}, -- Percs!
    {"29", "過剰摂取！", "その部屋に居る間、 受けるダメージが ハート1個分に増加"}, -- Addicted!
    {"30", "リ・ラックス", "2秒間うんちを出し続ける"}, -- Re-Lax
    {"31", "???", "現フロアに迷路の呪いを かける"},
    {"32", "オオキクナール", "アイザックのサイズ拡大#当たり判定は不変"}, -- One makes you larger
    {"33", "チイサクナール", "アイザックのサイズ縮小#当たり判定も縮小"}, -- One makes you small
    {"34", "感染性！", "部屋の全てのうんちを 壊し、同数の青クモを スポーンする"}, -- Infested!
    {"35", "感染症？", "部屋に居る敵と同数の 青クモをスポーンする#敵が居ない場合1～3匹の 青クモをスポーンする"}, -- Infested?
    {"36", "パワー ピル！", "6秒間パックマン化し、 以下の効果を得る：#無敵状態#全ての敵に恐怖状態付与#40の接触ダメージ#敵を2体倒すたび1/2ハート回復#涙攻撃不可"}, -- Power Pill!
    {"37", "レトロビジョン", "ゲーム画面が30秒間 ピクセル加工される"}, -- Retro Vision
    {"38", "最後までおともだち！", "青ハエを3匹スポーン"}, -- Friends Till The End!
    {"39", "ＫＯらっく", "茶色の液体が床に広がり、 アイザックをスリップ させる"}, -- X-Lax
    {"40", "何かがおかしい・・・", "黒い液体が床に広がり、 触れた敵をスロー状態に する"}, -- Something's wrong...
    {"41", "眠いなぁ・・・", "部屋の全ての敵を スロー状態にする"}, -- I'm Drowsy...
    {"42", "ワクワクする！", "部屋の全ての敵を 加速状態にする"}, -- I'm Excited!!!
    {"43", "ごっくん！", "保持中のトリンケットを 吸収し、効果を永続化する"}, -- Gulp!
    {"44", "バクバク！", "{{Collectible149}}吐き気薬の涙を一発放つ"}, -- Horf!
    {"45", "天国を歩いてる気分！", "6秒間無敵状態になり 移動速度が0.28増加 するが、攻撃能力を 一時的に失う"}, -- Feels like I'm walking on sunshine!
    {"46", "げふっ、ゲロ！", "最後に使用したピルを スポーンする"}, -- Vurp!
}

---------- Character Info ----------
-- These descriptions are shown in the Item Reminder
-- The character names here are also used in getPlayerName to provide localized character names
-- The numbers are provided to make this a quick reference for Player IDs
EID.descriptions[languageCode].CharacterInfo = {
	[0] = {"Isaac", ""},
	[1] = {"Magdalene", ""},
	[2] = {"Cain", ""},
	[3] = {"Judas", ""},
	[4] = {"???", "赤ハートを持てない#体力が増える効果は、 代わりに青ハート+1"},
	[5] = {"Eve", ""},
	[6] = {"Samson", ""},
	[7] = {"Azazel", "飛行#{{Collectible118}} 短射程のブリムストーンで攻撃"},
	[8] = {"Lazarus", "死ぬと、最大体力1の 復活ラザラスとして その部屋で復活する"},
	[9] = {"Eden", "ゲームを始めるたび初期 アイテムとステータスが ランダムに変動する"},
	[10] = {"The Lost", "飛行#透過効果付きの涙#{{Warning}} 体力なし#悪魔取引が一部屋につき 一回無料　　　"},
	[11] = {"Lazarus Risen", "↑ 移動速度#↑ 射程#↑ 運#↑ 攻撃力 x1.2"},
	[12] = {"Dark Judas", "↑ 攻撃力 x2#{{Player3}} 実績はユダとして扱う"},
	[13] = {"Lilith", "涙を撃てない#{{Collectible360}} インキュバスが 代わりに攻撃する"},
	[14] = {"Keeper", "コインで体力回復#最大体力2#ハートのピックアップは 青ハエに置き換わる"},
	[15] = {"Apollyon", ""},
	[16] = {"The Forgotten", "チャージで投てきも可能な、 骨による近接攻撃#骨ハート最大6#{{Player17}} {{ButtonRT}}でザ・ソウルに切替：#{{Blank}} 青／黒ハート最大6#{{Blank}} 飛行#{{Blank}} 透過効果付きの涙#鎖でフォーガットンに 縛られ、範囲内しか動けない"},
	[17] = {"The Forgotten Soul", "チャージで投てきも可能な、 骨による近接攻撃#骨ハート最大6#{{Player17}} {{ButtonRT}}でザ・ソウルに切替：#{{Blank}} 青／黒ハート最大6#{{Blank}} 飛行#{{Blank}} 透過効果付きの涙#鎖でフォーガットンに 縛られ、範囲内しか動けない"},
}

---------- Sacrifice Room ----------

EID.descriptions[languageCode].sacrificeHeader = "[次の生贄部屋の報酬]"

EID.descriptions[languageCode].sacrifice={
    {"1", "", "50%の確率でコインを1枚 スポーンする#1分以内にボスを倒し、 爆弾を未所持の場合、 爆弾を1個スポーンする ※一階層目でのみ有効"},
    {"2", "", "50%の確率でコインを1枚 スポーンする#1分以内にボスを倒し、 爆弾を未所持の場合、 爆弾を1個スポーンする ※一階層目でのみ有効"},
    {"3", "", "67%の確率で天使部屋の 出現率がアップする"},
    {"4", "", "50%の確率でランダムな 宝箱を1個スポーンする"},
    {"5", "", "33%の確率でコインを3枚 スポーンする#67%の確率で天使部屋の 出現率がアップする"},
    {"6", "", "33%の確率で天使部屋に テレポートする#そのフロアですでに悪魔 部屋が出現している場合 悪魔部屋にテレポート#67%の確率でランダムな 宝箱を1個スポーンする"},
    {"7", "", "33%の確率でランダムな 天使部屋アイテムを1個 スポーンする#67%の確率で青ハートを 1個スポーン"},
    {"8", "", "トロル爆弾を7個スポーン"},
    {"9", "", "ウリエルがスポーン"},
    {"10", "", "50%の確率で青ハートを7個 スポーンする#50%の確率でコインを30枚 スポーンする"},
    {"11", "", "ガブリエルがスポーン"},
    {"12", "", "50%の確率で真っ暗な部屋に テレポートする"},
}

---------- Dice Room ----------

EID.descriptions[languageCode].diceHeader = "[ダイス部屋の効果]"

EID.descriptions[languageCode].dice={
    {"1", "", "取得済みの全ての パッシブアイテムと アクティブアイテムを リロールする"},
    {"2", "", "部屋の全てのピック アップをリロールする"},
    {"3", "", "フロアの全てのピック アップとトリンケットを リロールする#悪魔部屋／天使部屋には 効果なし"},
    {"4", "", "フロアの全てのアイテムを リロールする#悪魔部屋／天使部屋には 効果なし"},
    {"5", "", "現在のフロアを再生成し、 リスタートする"},
    {"6", "", "取得済みの全ての パッシブアイテムと アクティブアイテムを リロールする#フロアの全てのピック アップとトリンケットと アイテムをリロールする"},
}

---------- Transformations ----------

EID.descriptions[languageCode].transformations={
    "",   				 -- 0 = none
    "Guppy",   		 -- 1
    "Fun Guy",   		 -- 2
    "Beelzebub",   	 -- 3
    "Conjoined",   	 -- 4
    "Spun",   			 -- 5
    "Yes Mother?",   	 -- 6
    "Oh Crap",   		 -- 7
    "Bob",   			 -- 8
    "Leviathan",   	 -- 9
    "Seraphim",   		 -- 10
    "Super Bum",   	 -- 11
    "Bookworm",   		 -- 12
    "Spider Baby",   	 -- 13
    "Adult",   		 -- 14
    "Stompy"   		 -- 15
}

---------- MISC ----------

-- a function that will get applied onto specific descriptions (glitched items, Abyss locusts,...) to pluralize them, make it nil to not pluralize
-- Each language can do their own algorithm to modify the given text to their needs
EID.descriptions[languageCode].PluralizeFunction = function(text, amount)
	-- English plural is very easy. Simply put an "s" at the end of specific words, if amount > 1
	-- replace {pluralize} placeholders inside the text with an "s"
	return EID:ReplaceVariableStr(text, "pluralize", amount > 1 and "s" or "")
end

EID.descriptions[languageCode].VoidText = "吸収した時："
-- {1} will become the number text (like "{1} Tears up" -> "+0.5 Tears up")
EID.descriptions[languageCode].VoidNames = {"{1} 移動速度アップ", "{1} 連射速度アップ", "{1} 攻撃力アップ", "{1} 射程アップ", "{1} 弾速アップ", "{1} 運アップ"}

EID.descriptions[languageCode].PurityBoosts = {[0] = "↑ 攻撃力 +4", "↑ 連射速度 +2", "↑ 移動速度 +0.5", "↑ 射程 +7.5#↑ 涙の高さ +1"}

EID.descriptions[languageCode].CrookedPennyHeads = "表"
EID.descriptions[languageCode].CrookedPennyTails = "裏"

EID.descriptions[languageCode].LuckModifier = "確率：運{2}で{1}%"

EID.descriptions[languageCode].CollectionPageInfo = "コレクションページに 登録されていない、 今まで未取得のアイテム"

EID.descriptions[languageCode].SingleUseInfo = "{{Warning}} 使い切りアイテム {{Warning}}"

EID.descriptions[languageCode].BlackFeatherInformation = "現在{{ColorLime}}{1}{{CR}}個の対象アイテムを 所持（攻撃力 +{2}）"

-- Find/replace pairs for changing "+1 Health" to "+1 Soul Heart" for soul health characters, or nothing at all for The Lost
-- {1} = number of hearts, {pluralize} = plural character
-- These texts are affected by the PluralizeFunction (ab+ file)
-- If having a simple plural character doesn't work for your language, you could just include an extra string pair to catch plural lines
EID.descriptions[languageCode].RedToX = {
	-- These change "+1 Health" to just "+1 Soul Heart" and etc.
	["Red to Soul"] = {"↑ 最大体力 +{1}", "青ハート +{1}",
	"↑ {{EmptyHeart}} +{1} Empty heart container{pluralize}", "{{SoulHeart}} +{1} Soul Heart{pluralize}",
	"↓ {{EmptyHeart}} {1} Health", "↓ {{SoulHeart}} {1} Soul Heart{pluralize}"},
	
	["Red to Black"] = {"↑ 最大体力 +{1}", "黒ハート +{1}",
	"↑ {{EmptyHeart}} +{1} Empty heart container{pluralize}", "{{BlackHeart}} +{1} Black Heart{pluralize}",
	"↓ {{EmptyHeart}} {1} Health", "↓ {{BlackHeart}} {1} Black Heart{pluralize}"},
	
	["Red to Bone"] = {"↑ 最大体力 +{1}", "骨ハート +{1}",
	"↑ {{EmptyHeart}} +{1} Empty heart container{pluralize}", "{{EmptyBoneHeart}} +{1} Empty Bone Heart{pluralize}", "{{HealingRed}}", "{{HealingBone}}",
	"↓ {{EmptyHeart}} {1} Health", "↓ {{EmptyBoneHeart}} {1} Bone Heart{pluralize}"}, -- Red HP to Bone Hearts
	
	["Red to Coin"] = {"↑ 最大体力 +{1}", "↑ 最大体力 +{1}",
	"↑ {{EmptyHeart}} +{1} Empty heart container{pluralize}", "{{EmptyCoinHeart}} +{1} Empty Coin Heart{pluralize}",
	"{{HealingRed}} Heals {1} heart{pluralize}", "{{HealingCoin}} Heals {1} coin{pluralize}", "{{HealingRed}} Heals half a heart", "{{HealingCoin}} Heals 1 coin", "{{HealingRed}}", "{{HealingCoin}}", "↓ {{EmptyHeart}} {1} Health", "↓ {{EmptyCoinHeart}} {1} Coin Heart{pluralize}"}, -- Red HP to Coin Hearts
	
	["Red to None"] = {"↑ 最大体力 +{1}", "", "↑ {{EmptyHeart}} +{1} Empty heart container{pluralize}", "", "↓ {{EmptyHeart}} {1} Health", ""}, -- Red HP to None (The Lost)
}

EID.descriptions[languageCode].MCM = {
    DemoObjectName = "Demo Object Name",
    DemoObjectTransformation = "Demo Transformation",
    DemoObjectText = "{{Collectible36}} オススメ設定#アイテム名の言語切替： General→NameLanguage 日本語／英語／日英併記#戦闘中のみ説明非表示： General→HideInBattle#ゲームのウィンドウを 少し横長に設定すると 左右に余白が生まれて 画面が見やすくなります",
}

-- the ItemReminder description will predict the abilities of items with a header like "Item Name Result"
EID.descriptions[languageCode].ItemReminder = {
	ResultHeader = "{1} 結果",
	InventoryEmpty = "(所持アイテムなし)",
	CategoryNames = {
		Overview = "インベントリの概要",
		Wisps = "レメゲトンのウィスプ",
		Special = "スペシャル",
		Actives = "アクティブアイテム",
		Pockets = "ポケットアイテム",
		Trinkets = "トリンケット",
		Passives = "パッシブアイテム",
		Character = "キャラクター情報",
	}
}

-- https://wofsauge.github.io/IsaacDocs/rep/enums/RoomType.html
-- Includes Repentance room types for localization convenience
EID.descriptions[languageCode].RoomTypeNames = { "通常の部屋", "お店", "I AM ERROR", "トレジャールーム", "ボス部屋", "中ボス部屋", "隠し部屋", "裏隠し部屋", "アーケード部屋", "呪い部屋", "チャレンジルーム", "図書館", "生贄部屋", "悪魔部屋", "天使部屋", "地下室", "ボスラッシュ部屋", "寝室", "汚れた寝室", "宝物庫", "ダイス部屋", "ブラックマーケット", "出口", "プラネタリウム", "テレポーター部屋", "テレポーター出口", "代替ルート入口", "青い部屋", "離れ隠し部屋",
-- Not technically room types but still potentially useful to have localized
[666] = "天使／悪魔部屋", [1024] = "赤い部屋", [1025] = "特殊な赤い部屋" }

-- currently used for D1 and Glyph of Balance; contains Rep pickups for ease of localization
EID.descriptions[languageCode].PickupNames = {
	["5.0"] = "None",

	["5.10"] = "{{Heart}} ハート",
	["5.10.1"] = "{{Heart}} ハート", ["5.10.2"] = "{{HalfHeart}} 半ハート", ["5.10.3"] = "{{SoulHeart}} 青ハート", ["5.10.4"] = "{{EternalHeart}} 白ハート", ["5.10.5"] = "{{Heart}} ハートｘ2", ["5.10.6"] = "{{BlackHeart}} 黒ハート", ["5.10.7"] = "{{GoldHeart}} 金ハート", ["5.10.8"] = "{{HalfSoulHeart}} 半青ハート", ["5.10.9"] = "{{Heart}} 脅えるハート", ["5.10.10"] = "{{BlendedHeart}} 混合ハート", ["5.10.11"] = "{{EmptyBoneHeart}} 骨ハート", ["5.10.12"] = "{{RottenHeart}} 腐ったハート",

	["5.20"] = "{{Coin}} コイン",
	["5.20.1"] = "{{Crafting8}} ペニー", ["5.20.2"] = "{{Crafting9}} ニッケル", ["5.20.3"] = "{{Crafting10}} ダイム", ["5.20.4"] = "{{Crafting8}} ダブルペニー", ["5.20.5"] = "{{Crafting11}} ラッキーペニー", ["5.20.6"] = "{{Crafting9}} 粘着ニッケル", ["5.20.7"] = "{{Crafting26}} ゴールデンペニー",

	["5.30"] = "{{Key}} 鍵",
	["5.30.1"] = "{{Crafting12}} 鍵", ["5.30.2"] = "{{Crafting13}} 金の鍵", ["5.30.3"] = "{{Crafting12}} 鍵ｘ2", ["5.30.4"] = "{{Crafting14}} 帯電した鍵",

	["5.40"] = "{{Bomb}} 爆弾",
	["5.40.1"] = "{{Crafting15}} 爆弾", ["5.40.2"] = "{{Crafting15}} 爆弾ｘ2", ["5.40.3"] = "{{Crafting15}} トロル爆弾", ["5.40.4"] = "{{Crafting16}} 金爆弾", ["5.40.5"] = "{{Crafting15}} メガトロル爆弾", ["5.40.7"] = "{{Crafting17}} 巨大爆弾",

	["5.42"] = "{{Crafting29}} Poop Nugget", ["5.42.1"] = "{{Crafting29}} Big Poop Nugget",

	["5.90"] = "{{Battery}} 電池",
	["5.90.0"] = "{{Crafting19}} 電池", --AB+ didn't have subtypes for batteries
	["5.90.1"] = "{{Crafting19}} 電池", ["5.90.2"] = "{{Crafting18}} ミニ電池", ["5.90.3"] = "{{Crafting20}} メガ電池", ["5.90.4"] = "{{Crafting28}} 金電池",

	["5.50"] = "{{Chest}} 宝箱", ["5.51"] = "{{BombChest}} 石宝箱", ["5.52"] = "{{SpikedChest}} トゲ付き宝箱", ["5.53"] = "{{EternalChest}} 白宝箱", ["5.54"] = "{{MimicChest}} 罠宝箱", ["5.55"] = "{{OldChest}} 古びた宝箱", ["5.56"] = "{{WoodenChest}} 木の宝箱", ["5.57"] = "{{MegaChest}} 巨大宝箱", ["5.58"] = "{{HauntedChest}} 呪いの宝箱", ["5.60"] = "{{GoldenChest}} 金宝箱", ["5.360"] = "{{RedChest}} 赤宝箱",

	["5.69"] = "{{GrabBag}} サック", ["5.69.1"] = "{{GrabBag}} サック", ["5.69.2"] = "{{BlackSack}} 黒サック",

	["5.70"] = "{{Pill}} ピル",
	["5.300"] = "{{Card}} カード",
	["5.301"] = "{{Rune}} ルーン", -- not a real id
	["5.350"] = "{{Trinket}} トリンケット",

}

-- Conditional descriptions - DO NOT TRANSLATE THE FIRST PART IN ["BRACKETS"]
-- Strings will be appended to the original description
-- Tables with one entry will completely replace the original description
-- Tables with two or more entries are find-replace pairs (if there's an odd number of entries, the last entry is appended)
-- For collectible/player conditionals, lines will automatically have their bulletpoint, and {1} is replaced with their name
EID.descriptions[languageCode].ConditionalDescs = {
	------ GENERAL STRINGS ------
	["Overridden"] = "{1}で上書きされる",
	["Overrides"] = "{1}を上書きする",
	["Almost No Effect"] = "{1}とはシナジーなし",
	["No Effect"] = "{1}には効果なし",
	["No Effect Replace"] = "{1}には効果なし", -- Useless Keeper items (The Wafer, Converter, Whore)
	["No Effect From"] = "{1}の効果なし",
	["Can't Charge"] = "{1}：チャージ不可",
	["Can't Be Charged"] = "{1}：チャージ不可",
	["Can't Be Duplicated"] = "複製できない",
	["No Effect (Greed)"] = "{{GreedMode}} グリードモードでは効果なし",
	["No Effect (Copies)"] = "複数所持でも効果なし", -- Having the item already, or having Diplopia while looking at a pedestal
	["No Effect (Familiars)"] = "追加の効果なし", -- probably just for Hive Mind + BFFS!
	["Different Effect"] = "{{ColorSilver}}{1}では効果が変化{{CR}}",
	["Dies on Use"] = "{{Warning}} {1}で使うと死ぬ", -- for Razor Blade and such as The Lost
	
	
	------ GREED MODE ------
	["Room to Wave"] = {"room", "wave", "room", "wave"}, -- convert room clear effects to wave clear effects
	["No Champion Drops"] = "!!! グリードモードでは、 チャンピオンタイプの 敵はピックアップを 落としません", -- Champion Belt / Purple Heart
	["5.300.15"] = {"{{DemonBeggar}} 悪魔乞食を1体スポーン"}, -- Temperance (Greed)
	["5.300.19"] = {"フロア開始時の部屋に テレポートする"}, -- The Moon (Greed)
--  ["5.300.20"] = {"{{HealingRed}} Full health#Deals 100 damage to all enemies"}, -- XIX - The Sun (Greed)
	["5.100.483 (Greed)"] = "{{GreedMode}} ウェーブごとではなく、 各部屋で一度ずつ爆発", -- Mama Mega (Greed)
	["5.100.535"] = "{{GreedMode}} シールド効果は最終 フロアでのみ有効", -- Blanket (Greed)
	["5.350.120"] = "{{GreedMode}} チャージ効果は最終 フロアでのみ有効", -- Hairpin (Greed)
--  ["5.100.246"] = {"{{SuperSecretRoom}} Reveals the Super Secret Room location on the map"}, -- Blue Map (Greed)
--  ["5.100.333"] = {"{{SuperSecretRoom}} Reveals the Super Secret Room location on the map"}, -- The Mind (Greed)
	["5.100.514"] = {"敵と弾がランダムな 間隔で遅延を起こす"}, -- Broken Modem (Greed)
	["5.350.34"] = {"宝箱・ｘ岩・破壊した 機械・殺した乞食から、 33%の確率でハートが 追加でスポーンする"}, -- Child's Heart
	["5.350.36"] = {"宝箱・ｘ岩・破壊した 機械・殺した乞食から、 33%の確率で鍵が追加で スポーンする"}, -- Rusted Key
	["5.350.41"] = {"宝箱・ｘ岩・破壊した 機械・殺した乞食から、 33%の確率で爆弾が 追加でスポーンする#!!! {{Trinket53}}ダニを除去できる"}, -- Match Stick
	["5.350.44"] = {"宝箱・ｘ岩・破壊した 機械・殺した乞食から、 33%の確率でピルが 追加でスポーンする"}, -- Safety Cap
	["5.350.45"] = {"宝箱・ｘ岩・破壊した 機械・殺した乞食から、 33%の確率でカードが 追加でスポーンする"}, -- Ace of Spades
	["5.350.72"] = {"ランダムピックアップが 電池になる確率 +2%#ウェーブをクリアした時、 5%の確率でアクティブ アイテムが1チャージ"}, -- Watch Battery
	["5.100.297 (Greed)"] = {"{{Warning}} 使い切りアイテム {{Warning}}#使用フロアで効果が変化：#Basement：爆弾と鍵 各2個#Caves：ボスアイテム1個 + 青ハート2個#Depths：コイン 20枚#Womb：ボスアイテム2個#Sheol：悪魔部屋アイテム1個 + 黒ハート1個#The Shop/Ultra Greed：コイン1枚"}, -- Pandora's Box
	
	
	------ ACHIEVEMENT CHECKS ------
	["5.350.23"] = "{{Warning}} 保持中に生贄部屋で死ぬと ザ・ロストをアンロック", -- Missing Poster (Unlock The Lost)
	["5.100.297"] = {"{{Collectible523}}お引越し用の箱をアンロック", "何もなし"}, -- Pandora's Box unlocking Moving Box
	
	
	------ SPECIFIC CHARACTER SYNERGIES/CHANGES ------
	-- NO RED HEALTH CHARS
	["Super Bandage Soul"] = {"青ハート +3"}, -- for Soul Heart chars
	["Super Bandage Black"] = {"青ハート +2#黒ハート +1"}, -- for Black Heart chars
	["Black Lotus Soul"] = {"青ハート +2#黒ハート +1"}, -- for Soul Heart chars
	["Black Lotus Black"] = {"青ハート +1#黒ハート +2"}, -- for Black Heart chars
	
	
	["5.100.135 (PHD)"] = "{1}所有時は2～3コイン", -- IV Bag PHD
	["Keeper 0-1"] = "{1}は0～1コイン （PHDよりも優先）", -- IV Bag/Piggy Bank Keeper
	["5.100.549"] = "{1}は取得時：# ↑ 連射速度 +0.4", -- Brittle Bones (Keeper+Lost)
	["5.100.501"] = "{1}：最大体力アップ可", -- Greed's Gullet
	["5.100.230 (Keeper)"] = "{{Warning}} {1}：取ると死ぬ", -- Abaddon
	

	------ DUPLICATE COPIES OF ITEMS ------
	["5.100.2 (Copies)"] = "同時発射数 +3#連射速度ダウンなし", -- The Inner Eye
	["5.100.153 (Copies)"] = "同時発射数 +4#連射速度ダウンなし", -- Mutant Spider
	["5.100.245 (Copies)"] = "同時発射数 +2", -- 20/20
	["5.100.358 (Copies)"] = "同時発射数 +2", -- The Wiz
--  ["5.100.64 (Copies)"] = "Owning this item a second time makes all Shop items free", -- Steam Sale
	["5.100.118 (Copies)"] = "ビームを追加で発射する", -- Brimstone
	["5.100.440 (Copies)"] = "移動速度 -0.2", -- Kidney Stone
	
	
	----- MISC. ITEM CONDITIONS ------
	["Sacrificial Nugget"] = "{{ColorYellow}}ブラウンナゲット{{CR}}の ハエは使い魔扱い",
	["Sacrificial Conception"] = "{1}から 生まれた使い魔も対象で、 その場合、生贄になった 使い魔はあとで復活する",
	["Sacrificial Angels"] = "{1}： 生贄に捧げられた時、 黒ハートを2個スポーン",
	["Sacrificial Void"] = "{{ColorYellow}}ボイド{{CR}}に吸収すると 何度でも使用できる",
	
--  ["5.100.116 (1 Room)"] = "1 Room recharges become 15 second recharges while in an uncleared room", -- 9 Volt
--  ["5.100.116 (Timed)"] = "Timed recharges start half full", -- 9 Volt
--  ["9 Volt 1 Room"] = "15 second recharge while in an uncleared room", -- Actives + 9 Volt
--  ["9 Volt Timed"] = "Charge starts half full after use", -- Actives + 9 Volt
	["5.100.205 (Wafer)"] = "チャージ時のダメージを 半ハートに軽減する", -- Sharp Plug + Wafer
	
	["Suicide 1"] = "{1}では死を防げない", -- Plan C, Damocles, Suicide King
	["Suicide 2"] = "{1}による死を防げない", -- Plan C, Damocles, Suicide King
	
--  ["5.100.7"] = "x1.5 Damage multiplier while {1} effect is active", -- Blood of the Martyr
--  ["5.100.34"] = "x1.5 Damage multiplier", -- Book of Belial
--  ["5.300.16"] = "x1.5 Damage multiplier", -- XV - The Devil
	
	["5.100.81"] = "赤ハートを持てないキャラは 青／黒ハートを1個にする", -- Dead Cat
--  ["5.100.316"] = "{1}removes the teleportation effect", -- Cursed Eye
--  ["5.100.260"] = "Removes the teleportation effect of {1}", -- Black Candle
	["Void Single Use"] = "使い切りアイテムは 一度だけ発動できる", -- Single Use Actives + Void
	["? Card Single Use"] = "使い切りアイテムは ？カードを使うと消失する", -- Single Use Actives + ? Card
	["5.300.48"] = "I AM ERRORにテレポート#白紙のカードと？カード 両方が消失する", -- Blank Card + ? Card
	["? + Blank Pedestal"] = "白紙のカードで？カードを 使うと、I _AM_ERRORに テレポートし、両カード共 消失する", -- Looking at Blank Card with ? Card
--  ["5.100.208"] = {20, 35, 5, 20}, -- Champion Belt + Hard Mode
	["5.100.521"] = "{{Collectible376}} 無料化すると、商品が 補充されなくなる", -- Coupon + Restock/Greed
	["Black Feather"] = "↑ 攻撃力 +0.2", -- Black Feather items
	
	["Bulb Multiple"] = "一番目のアイテムのみ参照", -- Vibrant/Dim Bulb + Schoolbag/Pocket Actives
	["Bulb Zero"] = "チャージバーが無い アイテムでは常に有効", -- Vibrant/Dim Bulb + zero charge actives
--  ["5.350.101 (Timed)"] = "Basically useless with timed recharges", -- Dim Bulb + Timed Recharges
	["5.100.122"] = "{1}は赤ハート1個以下で 有効化する", -- Whore of Babylon + Eve
	
	["5.70.28"] = "正面と真横に発射する", -- R U A Wizard + The Wiz
	["5.100.523"] = "パッシブアイテム扱いで吸収", -- Moving Box + Void
	["Mongo Babies"] = "{1}でコピー可", -- Mongo Baby + Baby Familiars
	["Technology 2 One Eye"] = "涙を撃てなくなる代わりに、 右目から{{Collectible68}}テクノロジーの レーザーを同時に発射する",
	["Brimstone Proptosis"] = "ビームはゼロ距離で 2倍のダメージを与え、 距離が離れるほど ダメージが低下する",
	["Brimstone Ipecac"] = "チャージ中に吐き気薬の 涙が発射される#レーザーのダメージ +40",
	["Proptosis Anti-Gravity"] = "静止中の涙はダメージと サイズを維持する",
	["Epic Fetus Soy Milk"] = "発射間隔は変わらず、 ダメージは大幅ダウン",
	["Eye of Belial Dr. Fetus"] = "爆弾は貫通するも、 追加ダメージを与えず、 ホーミングもしない",
	["Epic Fetus Brimstone"] = "{1}が優先される#爆発時、10本のレーザーを放つ",
	["Epic Fetus Mom's Knife"] = "{1}が優先される#爆発時、10本のナイフを放つ",
	["Haemolacria Brimstone"] = "{1}が優先される#涙が4～7本のレーザーを放つ",
	["Brimstone Mom's Knife"] = "{1}が優先される#チャージ量に応じてナイフの 弾幕が発射される",
	["Ludovico Ipecac"] = "攻撃力+4、毒・爆発なし",
	["Technology Ipecac"] = "攻撃力+4、毒効果付与",
	["Chocolate Milk Overrides"] = "↑ 連射速度 x1.25",
	["Chocolate Milk Marked"] = "照準との距離に応じて 連射速度とダメージが 自動的に切り替わる",
	["Ghost Pepper Fart"] = "おならと同時に炎を放つ",
	["Damage Multiplier Stack"] = "ダメージ倍率はスタックしない",
	["White Poop"] = "白いうんちをスポーン",
	["White Poop Chance"] = "白いうんちを確率スポーン",
	["Golden Poop Chance"] = "黄金うんちを確率スポーン",
--  ["5.100.483"] = "{{GoldenBomb}} 金爆弾を所持している時、 ママメガ！の代わりに それを消費して効果を 発動できる",
	
	["5.300.5"] = {"ランダムなボス部屋に テレポートする"}, -- IV - The Emperor (in The Void)
	["5.300.18"] = "トレジャールームが無い 場合、ランダムな部屋に テレポートする", -- XVII - The Stars (Womb and below)
	["5.300.18 (Greed)"] = {"ランダムなトレジャー ルームにテレポート"}, -- XVII - The Stars (Greed)
	["5.300.18 (Late Greed)"] = {"フロア開始時の部屋に テレポートする"}, -- XVII - The Stars (Greed Last Floors)
	["5.300.10"] = "お店が無い場合、ランダムな 部屋にテレポートする", -- IX - The Hermit (Womb and below)
	
}
